<?php
  class cAdminMenu extends cMenu
  {
    function __construct()
    {
      $menuItem = $this->AddItem("Študenti", "?site=student");
      $menuItem->AddItem("Zoznam", "?site=student&amp;action=list");
      $menuItem->AddItem("Pridať", "?site=student&amp;action=add");
      $menuItem->AddItem("Vyhľadať", "?site=student&amp;action=search_f");

      $menuItem = $this->AddItem("Učitelia", "?site=teacher");
      $menuItem->AddItem("Zoznam", "?site=teacher&amp;action=list");
      $menuItem->AddItem("Pridať", "?site=teacher&amp;action=add");
      $menuItem->AddItem("Vyhľadať", "?site=teacher&amp;action=search_f");

      $menuItem = $this->AddItem("Odbory", "?site=spec");
      $menuItem->AddItem("Zoznam", "?site=spec&amp;action=list");
      $menuItem->AddItem("Pridať", "?site=spec&amp;action=add");
      
      $menuItem = $this->AddItem("Predmety", "?site=course");
      $menuItem->AddItem("Zoznam", "?site=course&amp;action=list");
      $menuItem->AddItem("Pridať", "?site=course&amp;action=add");
      $menuItem->AddItem("Vyhľadať", "?site=course&amp;action=search_f");
      
      $this->AddItem("Import", "?site=import");

      $this->AddItem("Záloha", "?site=backup");

      $menuItem = $this->AddItem("Nastavenia", "?site=settings");
      $menuItem->AddItem("Zmena hesla", "?site=settings&amp;action=change_p");
      $menuItem->AddItem("Importovanie", "?site=settings&amp;action=change_i");
      
      $this->AddSeparator();

      $this->AddItem("Logout", "?site=main&amp;action=logout");
    }
  }  

  class cAdminPage extends cPage
  {
		protected $bPageSet;
		protected $error;
   
    function __construct( $smarty, $db, $action, $postParams, $getParams )
    {
			foreach ($getParams as &$item)
	  		$item = mysql_real_escape_string(htmlspecialchars($item, ENT_QUOTES));
	  
			foreach ($postParams as &$item)
	  		$item = mysql_real_escape_string(htmlspecialchars($item, ENT_QUOTES));
		  
      parent::__construct( $smarty, $db, $action, $postParams, $getParams );
    	$this->bPageSet = false;
    	$this->bLoggedIn = $this->LoggedAs("admin");
    	$this->error = "";

      $this->menu = new cAdminMenu();
    }
    
    protected function GetCourseList($error)
    {
      $courses = array();
      $query = "SELECT id FROM tCourse";
      $result = $this->db->QueryToArray($query);
      
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return NULL;
      }      

      for ( $i = 0; $i < count($result); $i++ )
        $courses[$i] = new cCourse($result[$i]["id"], $this->db);
        
      return $courses;      
    }
    
    protected function GetTeacherList(&$error)
    {
      $techers = array();
      $query = "SELECT u.id AS id FROM tUser AS u, tTeachers AS t WHERE u.id=t.id;";
      $result = $this->db->QueryToArray($query, MYSQL_ASSOC);
      
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return NULL;
      }      
      
      for ( $i = 0; $i < count($result); $i++ )
        $teachers[$i] = new cTeacher($result[$i]["id"], $this->db);
        
      return $teachers;      
    }
        
    protected function GenerateTeacherSelectList($selectedId, &$error)
    {
      $teachers = $this->GetTeacherList($error);
      $teacherList = NULL;
        
      $teacherList[0]["name"] = "---";
      $teacherList[0]["id"] = 0;
      $teacherList[0]["selected"] = false;
      
      for ( $i = 0; $i < count($teachers); $i++ )
      {
        $teacherList[$i+1] = $teachers[$i]->GetProperties();
        $teacherList[$i+1]["selected"] = ($teacherList[$i+1]["id"] == $selectedId);
      }     
      usort( $teacherList, "cmpUsers"); 
      return $teacherList;
    }

    protected function GenerateSpecSelectList($selectedId, &$error)
    {        
      $query = "SELECT * FROM tSpecialization ORDER BY name;";
      $result = $this->db->QueryToArray($query, MYSQL_ASSOC);
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return NULL;
      }            
      
      $specList[0]["name"] = "---";
      $specList[0]["id"] = 0;
      $specList[0]["selected"] = false;
      
      for ( $i = 0; $i < count($result); $i++ )
      {
        $specList[$i+1] = $result[$i];
        $specList[$i+1]["selected"] = ($specList[$i+1]["id"] == $selectedId);
      }
      usort( $specList, "cmpSpecializations"); 
      return $specList;      
    }
       
    protected function GetUserType($id, &$error)
    {
      $query = "SELECT * FROM tStudents WHERE id=".$id.";";
      if ( $this->db->QueryToRow($query) != 0 )
        return "student";
        
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return "";
      }

      $query = "SELECT * FROM tTeachers WHERE id=".$id.";";
      if ( $this->db->QueryToRow($query) != 0 )
        return "teacher";
      
      $error = $this->db->GetError();
      return "";
    }
    
    protected function Process()
    {
    }
    
    //vrati true, ak user nebol prihlaseny (zobrazi prihlasovaciu stranku)
    //ak vrati false, vykreslovanie sa necha na potomka
    protected function Draw()
    {
      //potomkovia mohli urobit zmeny v menu, prirad ho az teraz
      $this->smarty->assign( "menu", $this->menu );

      if ( !$this->bLoggedIn )
        $this->smarty->display("login.tpl");
      else
        $this->smarty->display("main.tpl");        
    }
    
		protected function GenerateRandomString( $length )
		{
      $values = array('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
                 			'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
                 			'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
                   		'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
                   		'1', '2', '3', '4', '5', '6', '7', '8', '9', '0');
          
      for($i = 0; $i <= $length-1; $i++)
      {
        $r = rand(0, count($values)-1);
        $key[$i] = $values[$r];
      }      
      return join("", $key);
		}
  }
?>
