<?php
	class cSpecializationPage extends cAdminPage
	{
    private $menuItem;

    function __construct( $smarty, $db, $action, $post, $get  )
    {
      parent::__construct( $smarty, $db, $action, $post, $get  );
      $this->menuItem = $this->menu->GetItemByLabel("Odbory");
      $this->menuItem->bSelected = true;
      $this->menuItem->bExpanded = true;

      if ( $this->getParams["id"] > 0 )
        $this->specialization = new cSpecialization($this->getParams["id"], $this->db); 
    }
    
    private function GetSpecList(&$error, $order)
    {
      $specList = array();
      $query = "SELECT s.id as id, s.name as name, s.id_garant as id_garant".
               " FROM tSpecialization as s LEFT JOIN tUser as u ON s.id_garant=u.id".
               " WHERE (s.id_garant=u.id OR s.id_garant=0)";
      
      if ( $order == "nameD" )
        $query .= " ORDER BY s.name DESC";
      else if ( $order == "garant" )
        $query .= " ORDER BY u.surname";
      else if ( $order == "garantD" )
        $query .= " ORDER BY u.surname DESC";
      else
        $query .= " ORDER BY s.name";
        
      $result = $this->db->QueryToArray($query);
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return NULL;
      }
      
      foreach ( $result as $specialization )
      {
        $specList[$specialization["id"]]["name"] = $specialization["name"];
        $specList[$specialization["id"]]["garant"] = NULL;
        if ( $specialization["id_garant"] > 0 )
        {
          $garant = new cTeacher( $specialization["id_garant"], $this->db );
          if ( $garant->Loaded() )
            $specList[$specialization["id"]]["garant"] = $garant->GetProperties(); 
        }
      }      
      $this->smarty->assign("order", $order);
      return $specList;            
    }

    private function VerifySpecValues(&$specValues, &$error)
    {
      $error = "";

      if ( empty( $this->postParams["name"] ) )
      {
        $this->smarty->assign("error", "Musíte zadať názov odboru!");
      }
      else 
      {
        $query = "SELECT * FROM tSpecialization WHERE name='".$this->postParams["name"]."'";
        if ( $this->specialization )
          $query .= " AND id<>".$this->specialization->GetID().";";
        else
          $query .= ";";
        $result = $this->db->QueryToRow($query);
        $error = $this->db->GetError();

        if ( $result == 0 && empty( $error ) )
        {
          $specValues["name"] = $this->postParams["name"];
          $specValues["id_garant"] = $this->postParams["garant"];
          return true;
        }
        else if ( $result != 0 )
          $this->smarty->assign("error", "Názov odboru už existuje!" );
      }
      return false;
    }

    function AddSpec(&$error)
    {
      if ( $this->VerifySpecValues($values, $error) )
      {
        $this->specialization = new cSpecialization(0, $this->db);
        return $this->specialization->DBCreate($values, $this->error);
      }
      return false;
    }
    
    function EditSpec(&$error)
    {
      if ( $this->VerifySpecValues($values, $error) )
      {
        if ( $this->specialization->DBEdit($values, $error) )
          return ($this->specialization->DBChangeGarant( $values["id_garant"], $error ) != NULL);
      }
      return false;
    }    
    
    function GetSpecInfo(&$error)
    {
      $this->smarty->assign("specialization", $this->specialization->GetProperties() );
      $garant = $this->specialization->GetGarant($error);            
      if ( !empty($error) )
        return false;
        
      if ( $garant->Loaded() )      
        $this->smarty->assign("garant", $garant->GetProperties() );
        
      $query = "SELECT * FROM tStudents WHERE id_specialization=".$this->specialization->GetID()." AND bkp=0;";
      $result = $this->db->QueryToArray($query);
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return false;
      }

      for ( $i = 0; $i < 8 && empty($error); $i++ )
      {      
        $students[$i] = $this->specialization->GetStudentsByYear($i+1, $error);
        $studentCount[$i] = count( $students[$i] );
      }
      $this->smarty->assign("students", $students );
      $this->smarty->assign("studentCount", $studentCount );
      return true;      
    }
    				
    function Process()
    {
      switch ( $this->action )
      {
        case "do_add":
          if ( $this->AddSpec($this->error) && $this->GetSpecInfo($this->error) )
          {
            $this->smarty->assign("actionInfo", "Odbor bol úspešne pridaný.");
            $this->bPageSet = true;
            break;
          }
          else if ( !empty( $this->error ) )
            return false;
          $this->action = "add";
        //fallthrough                  
        case "add":
          $teacherList = $this->GenerateTeacherSelectList(0, $this->error);
          if ( !empty( $this->error ) )
            return false;
            
          $this->smarty->assign("teachers", $teacherList);
          $this->smarty->assign("nameV", $this->postParams["name"]);
          $this->smarty->assign("formUrlSuffix", "&amp;action=do_add");
          $this->smarty->assign("buttonLabel","Pridať");
          $subMItem = $this->menuItem->GetItemByLabel("Pridať");
          $this->bPageSet = true;
        break;

        case "edit":
          if ( $this->specialization )
          {
            $garant = $this->specialization->GetGarant( $this->error );
            if ( !empty( $this->error ) )
              return false;
            
            $id = $garant ? $garant->GetID() : 0;              
            $teachers = $this->GenerateTeacherSelectList($id, $this->error);
            if ( !empty( $this->error ) )
              return false;

            $courseValues = $this->specialization->GetProperties();
            $this->smarty->assign("teachers", $teachers);
            $this->smarty->assign("nameV", $courseValues["name"]);
            $this->smarty->assign("formUrlSuffix", "&amp;action=do_edit&amp;id=".$this->specialization->GetID());
            $this->smarty->assign("pageTitle","Editovanie odboru");
            $this->smarty->assign("buttonLabel","Editovať");
            $this->smarty->assign("specialization", $this->specialization->GetProperties());
            $this->bPageSet = true;
          }     
        break;

        case "do_edit":
          if ( $this->specialization )
          {            
            if ( !$this->EditSpec($this->error) )
            {
              if ( !empty( $this->error ) )
                return false;
                
              $this->action = "edit";            
              $teachers = $this->GenerateTeacherSelectList($this->postParams["garant"], $this->error);
              if ( !empty( $this->error ) )
                return false;
  
              $this->smarty->assign("teachers", $teachers);
              $this->smarty->assign("nameV", $this->postParams["name"]);
              $this->smarty->assign("formUrlSuffix", "&amp;action=do_edit&amp;id=".$this->specialization->GetID());
              $this->smarty->assign("pageTitle","Editovanie odboru");
              $this->smarty->assign("buttonLabel","Editovať");
              $this->smarty->assign("course", $this->specialization->GetProperties());
              $this->bPageSet = true;
            }
            else
            {            
              if ( $this->GetSpecInfo($this->error) )
                $this->bPageSet = true;
              else if ( !empty($this->error) )
                return false;
            }
          }
        break;   
        
        case "do_delete":
          if ( $this->specialization )
          {
            if ( $this->specialization->DBDelete($this->error) )
              $this->smarty->assign("actionInfo", "Odbor bol vymazaný z databázy.");
            if ( !empty($this->error) )
              return false;
          }            
        break;
        
        case "delete":
          if ( $this->specialization )
          {
            $this->smarty->assign("specialization", $this->specialization->GetProperties() );
            $this->bPageSet = true;          	
          }
        break;
        
        case "info":
          if ( $this->specialization )
          {  
            if ( $this->GetSpecInfo($this->error) )
              $this->bPageSet = true;
            else if ( !empty($this->error) )
              return false;
          }          
        break;
      } 

      if ( $this->bPageSet == false )
      {
        $subMItem = $this->menuItem->GetItemByLabel("Zoznam"); 
        $order = empty( $this->getParams["order"] ) ? "name" : $this->getParams["order"];       
        $specList = $this->GetSpecList($this->error, $order );  
        if ( !empty( $this->error ) )
          return false;
        $this->smarty->assign("specs", $specList);
        $this->smarty->assign("specCount", count($specList));
      } 

      if ( $subMItem )
      {
        $this->menuItem->bSelected = false;
        $subMItem->bSelected = true;
      }
      return true;
    }
    
    function Draw()
    {
      if ( !$this->bPageSet )
      {
        $this->smarty->assign("content", "specList.tpl");
        $this->smarty->assign( "title", "Zoznam odborov" );
      }
      else
      {
        switch ( $this->action )
        {
          case "add":
            $this->smarty->assign("content", "specForm.tpl");
            $this->smarty->assign("title", "Pridávanie odboru");
          break;

          case "edit":
            $this->smarty->assign("content", "specForm.tpl");
            $this->smarty->assign("title", "Editovanie odboru" );
          break;
          
          case "delete":
            $this->smarty->assign("content", "specDelete.tpl");
            $this->smarty->assign("title", "Vymazanie odboru" );
          break;          
          
          case "do_edit":
          case "do_add":
          case "info":
            $this->smarty->assign("content", "specDetails.tpl");
            $this->smarty->assign("title", "Informácie o odbore");
          break;
        }
      }
      parent::Draw();
    }
	}
?>
