<?php
	/* 
		*** pracovna verzia ***
		zmeny oproti povodnej verzii
		- trieda je abstraktna
		- konstruktor ma novy parameter $appDir, kde je cesta k aplikacii, napr. "/home/probatur/public_html/student/"
		- nova abstraktna metoda GetPageById (vrati pozadovaneho potomka triedy cPage)
		- zrusena ficurka na predavanie POSTovskych a GETovskych parametrov
	*/
	abstract class cApplication
	{
		protected $db;
		protected $site;
		protected $action;
		protected $smarty;
		
		function __construct( $db, $appDir )
		{
			$this->smarty = new Smarty();
			$this->smarty->template_dir = $appDir."smarty/templates";
			$this->smarty->compile_dir = $appDir."smarty/templates_c";
			$this->smarty->cache_dir = $appDir."smarty/cache";
			$this->smarty->config_dir = $appDir."smarty/configs";			
			
			$this->db = $db;
			session_start();
		}
		
		function __destruct()
		{
			$this->db->Disconnect();
		}
		
		abstract function GetPageById($pageId);
		/*
			vrati potomka triedy cPage, ktory ma byt spracovany na zaklade pozadovaneho id
		*/
		
    function Run()
    {
      $siteID = isset( $_GET["site"] ) ? $_GET["site"] : "main";
      $this->action = isset( $_GET["action"] ) ? $_GET["action"] : 0;
      $this->site = $this->GetPageById($siteID);

      if ( $this->site->Process() )            
        $this->site->Draw();
      else
        $this->site->SayError();
        	    
      session_write_close();
    }
	}
?>
