<?php
/*
*	NOTE: 
*	Velmi jednoducha 'abstrakcia' nad db, hovorili sme o tom, ze by sa tazsie vytvarala medzivrstva na vyssej urovni,
*	(robime oddelene a casu vela neostava)
*	Ktokolvek z nas moze tuto triedu rozsirovat a vylepsovat, konstrukcia queries ostava na vyssej vrstve
*/
	abstract class cAbstractDB
	{
		protected $db;
		protected $result;
		protected $error;
		protected $host;
		protected $dbName;
		protected $user;
		protected $pass;

		/*
			Vytvori spojenie s db serverom a connect na databazu
			Ako parametre pouzije hodnoty v $this->host, $this->dbName, $this->user, $this->pass,
			ktore musia byt inicializovane v konstruktore odvodenych tried
			
			$persitstent ak true, tak vytvori perzistente spojenie s db
		*/
		abstract function Connect( $persistent );

		/*
			Ukonci db spojenie
		*/
		abstract function Disconnect();
		
		/*
			Vrati chybu poslednej db operacie
		*/
		abstract function GetError();
		
		/*
			Vrati true, ak nastala chyba, false v opacnom pripade
		*/
		function IsError()
		{
			return $this->error != "";
		}
		
		/*
			Vykona query nad databazou, query je sql prikaz (napr. SELECT..., UPDATE..., INSERT INTO...)
		*/
		abstract function Query( $query );

		/*
			Vykona query a v pripade ze result obsahuje aspon jeden riadok, vrati do pola hodnotu prveho z nich
			
			$fetchType moze nadobudat MYSQL_NUM, MYSQL_ASSOC, MYSQL_BOTH
		*/
		abstract function QueryToRow( $query, $fetchType=MYSQL_BOTH);
		
		/*
			Vykona query a v pripade ze result obsahuje aspon jeden riadok, vrati vysledok v 2d poli
			
			$fetchType moze nadobudat MYSQL_NUM, MYSQL_ASSOC, MYSQL_BOTH
		*/
		abstract function QueryToArray( $query, $fetchType=MYSQL_BOTH );

		/*
			Vrati pocet riadkov vysledku sql operacie predanej metode v param. $result
		*/			
		abstract function NumRows( $result );
	}
	
	
	class cMySqlDB extends cAbstractDB
	{
		function __construct( $nHost, $nUser, $nPass, $nDbName )
		{
			$this->host = $nHost;
			$this->user = $nUser;
			$this->pass = $nPass;
			$this->dbName = $nDbName;
			$this->error = "";
		}

		function Connect( $persistent )
		{	
			if ( !$persistent )
				$this->db = mysql_connect($this->host,$this->user,$this->pass);
			else
				$this->db = mysql_pconnect($this->host,$this->user,$this->pass);
			
			if ( !$this->db )	
				die("DB Server appears to be down.");
				
			mysql_select_db($this->dbName) or die("Database not found.");
		}

		function Disconnect()
		{
			mysql_close($this->db);
		}

		function GetError()
		{
			$this->error = mysql_error();
			return $this->error;
		}

		function Query( $query )
		{
			$this->error = "";
			$this->result = mysql_query( $query );

			if( !$this->result )
			{
				$this->GetError();
				return 0 ;
			}

			return $this->result;
		}

		function QueryToRow( $query, $fetchType=MYSQL_BOTH )
		{		
			$this->error = "";
			$this->result = mysql_query( $query );

			if( !$this->result )
			{
				$this->GetError();
				return 0 ;
			}

     		if( $this->NumRows( $this->result ) > 0 )
				return mysql_fetch_array( $this->result, $fetchType );

			return 0;
		}
		
		function QueryToArray( $query, $fetchType=MYSQL_BOTH )
		{
			$this->error = "";
			$this->result = mysql_query( $query );
			
			if( !$this->result )
			{
				$this->GetError();
				return 0;
			}
			
			$result = array();
			
			for( $i = 0; $i < $this->NumRows( $this->result ); $i++ )
			{
				$result[$i]	= mysql_fetch_array( $this->result, $fetchType );
			}
			return $result;
		}

		function NumRows( $result )
		{
			$this->error = "";
			return mysql_num_rows( $result );
		}
		
		function InsertId()
		{
			$this->error = "";
			return mysql_insert_id();
		}
	}
	
	
	class cPostgreSqlDB extends cAbstractDB
	{
		function __construct( $nHost, $nUser, $nPass, $nDbName )
		{
			$this->host = $nHost;
			$this->user = $nUser;
			$this->pass = $nPass;
			$this->dbName = $nDbName;
			$this->error = "";
		}

		function Connect( $persistent )
		{
			$connString = "host=$this->host dbname=$this->nDbName user=$this->user password=$this->pass";
			if ( !$persistent )
				$this->db = pg_connect($connString);
			else
				$this->db = pg_pconnect($connString);
				
			if ( !$this->db )
				 die("DB Server appears to be down.");
		}

		function Disconnect()
		{
			pg_close($this->db);
		}

		function GetError()
		{
			$this->error = pg_last_error();
			return $this->error;
		}

		function Query( $query )
		{
			$this->error = "";
			$this->result = pg_query( $this->db, $query );

			if( !$this->result )
			{
				$this->GetError();
				return 0 ;
			}

			return $this->result;
		}

		function QueryToRow( $query, $fetchType=MYSQL_BOTH )
		{
			$this->error = "";
			$this->result = pg_query( $this->db, $query );

			if( !$this->result )
			{
				$this->GetError();
				return 0 ;
			}

     		if( $this->NumRows( $this->result ) > 0 )
				return pg_fetch_array( $this->result, 0, $fetchType );

			return 0;
		}
		
		function QueryToArray( $query, $fetchType=MYSQL_BOTH )
		{
			$this->error = "";
			$this->result = pg_query( $this->db, $query );
			
			if( !$this->result )
			{
				$this->GetError();
				return 0;
			}
			
			$result = array();
			
			for( $i = 0; $i < $this->NumRows( $this->result ); $i++ )
			{
				$result[$i]	= pg_fetch_array( $this->result, $i, $fetchType );
			}
			return $result;
		}

		function NumRows( $result )
		{
			return pg_num_rows( $result );
		}
	}	
?>