#!/bin/sh
echo "APT::Install-Recommends \"false\";" >> /etc/apt/apt.conf
apt-get -y install selinux-policy-default

#setup integrity checks
#beware, aide on debian has lotads of wrapper scripts.
aide --init
cp /var/lib/aide/aide.db.new /var/lib/aide/aide.db

#setup automatic security updates
cp /tmp/postinst/security_sources.list /etc/apt/security_sources.list

#cron apt will attempt dist-update every 4 o'clock

#we force it to use only security sources
  echo OPTIONS="-o quiet=1 -o Dir::Etc::SourceList=/etc/apt/security_sources.list -o Dir::Etc::SourceParts=\"/dev/null\"" >> /etc/cron-apt/config

#setup firewall
  cp /tmp/postinst/firewall /etc/init.d/firewall
  chmod 700 /etc/init.d/firewall
  update-rc.d firewall defaults

#setup remote syslog
echo "*.* @@syslog.infrastructure.local" >> /etc/rsyslog.conf

#setup pam-nss-ldap
mv /tmp/postinst/nsswitch.conf  /etc/nsswitch.conf
#setup mysql
mv  /tmp/postinst/my.cnf /etc/mysql/my.cnf

#setup passwd change to ldap
mv  /tmp/postinst/common-password /etc/pam.d/common-password
#setup pseudoroot account with access to /etc/mysql
chown -R 2001:2001 /etc/mysql
mv  /tmp/postinst/sudoers /etc/sudoers
chmod 0440 /etc/sudoers

#database dump
mkdir -p /opt/postfixdb-postinst/
cp /tmp/postinst/postfixdump.db /opt/postfixdb-postinst/
cp /tmp/postinst/installscheme.sh /opt/postfixdb-postinst/ 
chmod +x /opt/postfixdb-postinst/installscheme.sh  
