#!/bin/sh
echo "APT::Install-Recommends \"false\";" >> /etc/apt/apt.conf
apt-get -y install selinux-policy-default

#setup integrity checks
#beware, aide on debian has lotads of wrapper scripts.
aide --init
cp /var/lib/aide/aide.db.new /var/lib/aide/aide.db

#setup automatic security updates
cp /tmp/postinst/security_sources.list /etc/apt/security_sources.list

#cron apt will attempt dist-update every 4 o'clock

#we force it to use only security sources
  echo OPTIONS="-o quiet=1 -o Dir::Etc::SourceList=/etc/apt/security_sources.list -o Dir::Etc::SourceParts=\"/dev/null\"" >> /etc/cron-apt/config

#setup firewall
  cp /tmp/postinst/firewall /etc/init.d/firewall
  chmod 700 /etc/init.d/firewall
  update-rc.d firewall defaults

#setup syslog
echo "*.* @@syslog.infrastructure.local" >> /etc/rsyslog.conf

#setup ca
mkdir -p /var/ssl

#setup CA.pl 
mv /tmp/postinst/CA.pl /usr/lib/ssl/misc/CA.pl 
#setup /etc/ssl/openssl.cnf
mv /tmp/postinst/openssl.cnf /etc/ssl/openssl.cnf

#setup lighttpd for dirlisting
mv /tmp/postinst/lighttpd.conf /etc/lighttpd/lighttpd.conf

