#!/bin/sh
echo "APT::Install-Recommends \"false\";" >> /etc/apt/apt.conf
apt-get -y install selinux-policy-default

#setup integrity checks
#beware, aide on debian has lotads of wrapper scripts.
aide --init
cp /var/lib/aide/aide.db.new /var/lib/aide/aide.db

#setup automatic security updates
cp /tmp/postinst/security_sources.list /etc/apt/security_sources.list

#cron apt will attempt dist-update every 4 o'clock

#we force it to use only security sources
  echo OPTIONS="-o quiet=1 -o Dir::Etc::SourceList=/etc/apt/security_sources.list -o Dir::Etc::SourceParts=\"/dev/null\"" >> /etc/cron-apt/config

#setup firewall
  cp /tmp/postinst/firewall /etc/init.d/firewall
  chmod 700 /etc/init.d/firewall
  update-rc.d firewall defaults

#setup rsyslog
cp /tmp/postinst/rsyslog.conf /etc/rsyslog.conf

apt-get -y install logwatch
cp -R /usr/share/logwatch/default.conf /etc/logwatch/conf/
mkdir -p /var/cache/logwatch

#Configure email
cp /tmp/postinst/update-exim4.conf.conf /etc/exim4/
cp /tmp/postinst/exim-auth-01_gmail_smtp /etc/exim4/conf.d/auth/01_gmail_smtp
cp /tmp/postinst/exim-router-201_exim_gmail_satelite /etc/exim4/conf.d/router/201_exim_gmail_satelite
cp /tmp/postinst/exim-transport-30_exim4-config_remote_smtp_smarthost /etc/exim4/conf.d/transport/30_exim4-config_remote_smtp_smarthost

rm /etc/exim4/conf.d/auth/30_exim4-config_examples
update-exim4.conf

#configure apache for serving Nagios and Munin
ln -s /etc/munin/apache.conf /etc/apache2/sites-available/munin
ln -s /etc/nagios3/apache2.conf /etc/apache2/sites-available/nagios

cp /tmp/postinst/nagios.conf /etc/nagios3/apache2.conf 
cp /tmp/postinst/host* /etc/nagios3/conf.d/
cp /tmp/postinst/services_nagios2.cfg /etc/nagios3/conf.d/
cp /tmp/postinst/cgi.cfg /etc/nagios3/cgi.cfg
cp /tmp/postinst/httpd.conf /etc/apache2/httpd.conf 
cp /tmp/postinst/server.htpasswd /etc/apache2/server.htpasswd 

rm /var/www/*
mkdir /var/www/munin
mkdir /var/www/nagios3
mkdir /var/www/logwatch

a2enmod ssl
a2endisite default-ssl
a2ensite munin
a2ensite nagios

#set logwatch to sumarize logs to web-folder as well
cp /tmp/postinst/00logwatch /etc/cron.daily/00logwatch
chmod +x /etc/cron.daily/00logwatch
