function RecordPlayer(){
  this.audioContext = null;
  this.floatBuffer = null;
}

var mfccWorker = new Worker("javascript_workers/mfccWorker.js");

 
 
RecordPlayer.prototype.init = function(){
    try {
      this.audioContext = new (window.AudioContext || window.webkitAudioContext)();
      
    } catch(err) {
      
      
    }
    console.log("init");
}

var floatBuffer;
var energies = [];
var energies25 = [];
var mfcc25 = [];


RecordPlayer.prototype.play = function(buffer, path){
  energies = this.calculateEnergies(buffer);
  
  var text = "<pre>";
  for (var i = 0 ; i < energies.length; i++){
    text += (i*50)+"   <strong>"+i+".</strong>   "+energies[i]+" <br>";    
  }
  text += "</pre>";
  
  
  $('#right').html(text);
  // poslat 
  this.floatBuffer = this.convertInt16ToFloat32(buffer);    
  this.createMFCCandE25(buffer);
  
  //toolsSendEnergies(energies);
  
  //this.floatBuffer = this.convertInt16ToFloat32(buffer);    
  //this.__play(true);
}



  

RecordPlayer.prototype.convertInt16ToFloat32 = function(buffer){
  
  var result = new ArrayBuffer(buffer.byteLength * 2);
  var dataViewInput = new DataView(buffer, 0, buffer.byteLength); 
  var dataViewResult = new DataView(result, 0, result.byteLength); 
  
  for (var i = 0; i < buffer.byteLength / 2; i++){
    var f = dataViewInput.getInt16(i*2,true);
    if (f<0){
        f = f / 32768;            
    } else {
        f = f / 32767;
    }  

    dataViewResult.setFloat32(i*4, f, true);    
  }  
  return result;   
}

RecordPlayer.prototype.removeFile = function(path){
  this.floatBuffer = null;
}

RecordPlayer.prototype.playAgain = function(){
  if (this.floatBuffer == null)
    return;
  this.__play(false);
}


RecordPlayer.prototype.__play = function(show){
  try {
    
   
    var source = this.audioContext.createBufferSource();
    source.connect(this.audioContext.destination);
    
    var audioBuffer = this.audioContext.createBuffer( 1, this.floatBuffer.byteLength / 4, 16000 );      
    var floatBufferView = new DataView(this.floatBuffer, 0, this.floatBuffer.byteLength);
    var outputBuffer = audioBuffer.getChannelData( 0 );
    
    for (var i = 0; i < this.floatBuffer.byteLength / 4; i++) {
      outputBuffer[i] = floatBufferView.getFloat32(i*4,true);
    }
    
    source.buffer = audioBuffer;
    
    source.onended = function() {
      console.log('Your audio has finished playing');
      toolsShowActions();      
    }
    
    source.start( 0 );     

  } catch(err){
    console.log("error");
    console.log(err);
  } 
}

var dataLen = 1600; // plati pre okno velkosti 100
// 48000 / (1000/100) / ratio//  16000 / (1000/100);
RecordPlayer.prototype.calculateEnergies = function(buffer){ 
  var arr = [];
  var dataViewInput = new DataView(buffer, 0, buffer.byteLength); 
  
  for (var i = 0; i < buffer.byteLength / 2; i++){
    var f = dataViewInput.getInt16(i*2,true);
    if (f<0){
        f = f / 32768;            
    } else {
        f = f / 32767;
    }  
    arr.push(f); 
  }  
  
  var k = 0;
  
  var len = Math.floor(buffer.byteLength/ 2 / dataLen) * 2 - 1;
  var res = [];
  
  for (var i = 0; i < len; i++){
    var energy = 0;
    for (var j = 0; j < dataLen; j++){
      energy += arr[i*(dataLen/2)+j]*arr[i*(dataLen/2)+j];      
    }    
    res.push(energy)
  }
  
  return res; 
 
}
var dataLen25 = 400; // plati pre okno velkosti 100
var dataLen25WithZeros = 512;
var maxIt;
// 48000 / (1000/25) / ratio ///////////  16000 / (1000/25);
RecordPlayer.prototype.createMFCCandE25 = function(buffer){ 
  var arr = [];
  var dataViewInput = new DataView(buffer, 0, buffer.byteLength); 
  
  for (var i = 0; i < buffer.byteLength / 2; i++){
    var f = dataViewInput.getInt16(i*2,true);
    if (f<0){
        f = f / 32768;            
    } else {
        f = f / 32767;
    }  
    arr.push(f); 
  }  
    var k = 0;
  
  var len = Math.floor(buffer.byteLength/ 2 / dataLen25) * 2 - 1;
  maxIt = len-1;
  
  
  for (var i = 0; i < len; i++){
    var windowData = [];
    for (var j = 0; j < dataLen25; j++){
      windowData.push(arr[i*(dataLen25/2)+j]);
    }    
    mfccWorkerHandler(mfccWorker, addLittleNoiseAndZeros(windowData), dataLen25WithZeros, i==len-1?true:false); 
  }
  
  
}
function addLittleNoiseAndZeros(data){
    var outputData = [];
    for (var i = 0; i < data.length; i++){
        outputData.push(data[i] + Math.random()/100000);
    }
  
    // aj nulam pridat sum? nie!
    for (var i = outputData.length; i < dataLen25WithZeros; i++){
        outputData.push(0);
    }
    return outputData;  
}

var mfccWorkerHandler = function(worker, data, length, last){       
  
  worker.onmessage = function(e){ 
    //console.log(e.data.it);
    //console.log(e.data.result);
    energies25.push(e.data.energy);
    mfcc25.push(e.data.result);
    if (e.data.it == maxIt){
      console.log("last");

      
      toolsSendEnergies(energies,mfcc25,energies25);
      energies = [];
      mfcc25 = [];
      energies25 = [];
      recordPlayer.__play(true);
    }
  };
  worker.postMessage({
      'data': data,
      'size': length,
      'last': last
  });
};








