// ------------------------ STATES ---------------------------------------

var GAME_STATE_READY= 0;
var GAME_STATE_PAUSED= 1;
var GAME_STATE_RUNNING = 2;
var GAME_STATE_ENDED = 4;
var GAME_STATE_READING = 5;

var HEAD_STATE_UP = 0;
var HEAD_STATE_DOWN = 2;
var HEAD_STATE_LEFT = 1;
var HEAD_STATE_RIGHT = 3;
var UPDATE_RATE = 500;
// ------------------------ GLOBAL VARIABLES ----------------------------------

// images
var image_head_up = new Image();  
var image_head_down = new Image();
var image_head_left = new Image();
var image_head_right = new Image();
var image_tail = new Image();

// ------------------------ GAME OBJECT DEFINITION ----------------------------


var stats = [0,0,0];
var Game = {
  
    answer: true,
    game_state: 0,
    canvas: null,
    context: null,
    head_state: 0,
    snake_x: [5], //[5,5,5,5,5,5], // headx je prve
    snake_y: [5], //[5,6,7,8,9,0], // heady je prve
    tail_letter: ['hlava'], 
  
  
    letters: LETTERS,
    
    letter_queue: [],
    queue_it: 0,
    letter_trash: [],
    
    spawn_letter: 'a',
    spawn_x: -1,
    spawn_y: -1,
    spawn_rect_r : 0,
    spawn_rect_g : 0,           
    spawn_rect_b : 0,
    ticks_left: READING_UPDATES,  // cas na odpoved
    answer_tick_left: ANSWER_UPDATES, // cas zobrazenia vysledku
    
    //correct: false,
    grow: false,
    grow_letter: 'r',
    score: 0,
  
    init: function(myCanvas){   
      this.canvas = myCanvas;
      this.context = this.canvas.getContext("2d");
      var i = 0;
      while(i<GAME_LENGTH){
          var let = this.letters[Math.floor((Math.random() * this.letters.length))];
      
          if (UNIQUE){
            while(this.letter_queue.indexOf(let,0)!=-1){
              let = this.letters[Math.floor((Math.random() * this.letters.length))];
            } 
          }
          this.letter_queue.push(let);
          
          i++;     
      }
    },
    
    update: function(){
       // update body
       if (this.game_state == GAME_STATE_READING){
    	   this.grow = this.updateReading();
    	   if (this.grow!=null){
             if (!this.grow){
               this.letter_trash.push(this.spawn_letter);
             }
             console.log("g: "+this.grow);    	     
             this.answer = true;
    	   } 
    	   return;
       }
       //pre grow, novy bude na poslednej pozici
       var x=this.snake_x[this.snake_x.length-1];
       var y=this.snake_y[this.snake_y.length-1];
       
	   for (var i=this.snake_x.length-1;i>0;i--){
		   this.snake_x[i]=this.snake_x[i-1];
		   this.snake_y[i]=this.snake_y[i-1];
	   }
     if (this.grow==true){
 	       this.score += 10;
		   this.snake_x.push(x);
		   this.snake_y.push(y);
		   this.tail_letter.push(this.grow_letter);
		   this.grow=false;
		   
	   } 
	   // update head
	   if (this.head_state == HEAD_STATE_UP){
		   this.snake_y[0]--;
    	   if (this.snake_y[0]==-1) 
    		   this.snake_y[0] = TILES - 1;   
       }
	   if (this.head_state == HEAD_STATE_DOWN){
		   this.snake_y[0]++;
    	   if (this.snake_y[0]==TILES) 
    		   this.snake_y[0] = 0;   
       }
	   if (this.head_state == HEAD_STATE_LEFT){
		   this.snake_x[0]--;
    	   if (this.snake_x[0]==-1) 
    		   this.snake_x[0] = TILES - 1;   
       }
	   if (this.head_state == HEAD_STATE_RIGHT){
		   this.snake_x[0]++;
    	   if (this.snake_x[0]==TILES) 
    		   this.snake_x[0] = 0;   
       }
       if (this.spawn_x == -1 && this.spawn_y == -1 )
    	   this.createSpawn();
       
	   this.checkCollision();
    },
    
    updateReading: function(){
    	//if (answer == true || this.ticks_left==0)
        if (this.ticks_left==0){
           
    		this.ticks_left = 0;
            if (this.answer_tick_left == 1){
              console.log("skoncil cas");
            }
    		this.answer_tick_left--;
            
    		if (this.answer_tick_left==0){
    			this.ticks_left = READING_UPDATES;
    			this.answer_tick_left = ANSWER_UPDATES;
    			this.game_state = GAME_STATE_RUNNING;
    			this.grow_letter = this.spawn_letter;
    			return this.answer;
    		}
    		return null;		
    	}
    	this.ticks_left--;
    	return null;
    	    	
    },
    
    checkCollision: function(){
    	for (var i = 1; i<this.snake_x.length;i++){
    		if(this.snake_x[0] == this.snake_x[i] && this.snake_y[0] == this.snake_y[i]){
    			this.game_state = GAME_STATE_ENDED;    			
    		}	
    	}
    	
    	if (this.snake_x[0] == this.spawn_x && this.snake_y[0] == this.spawn_y){
    		this.answer = true;
            setTested(this.spawn_letter);
           
    		setUploadState(1);
  			this.game_state = GAME_STATE_READING; 
  			this.spawn_x = -1;
  			this.spawn_y = -1;
	   	}
    	
    	
    	
    },
    createSpawn: function(){
      if (this.queue_it == GAME_LENGTH){
        console.log("koniec");
        this.game_state = GAME_STATE_ENDED;
        this.spawn_x = -1;
        this.spawn_y = -1;
        return;
      }
    	this.spawn_letter = this.letter_queue[this.queue_it];
    	var x = Math.floor((Math.random() * TILES));
    	var y = Math.floor((Math.random() * TILES));
    	var done = false;
    	while(!done){
    		done = true;
    		var i = 0;
    		for (i;i<this.snake_x.length;i++){
    			if (this.snake_x[i]==x && this.snake_y[i]==y){
    				x=(x+1) % TILES;
    				if (x==0)
    				  y = (y+1) % TILES; 
    				done=false;	
    			}
    	    }  
    		
    	}
      this.spawn_rect_r = Math.floor((Math.random() * 255));
      this.spawn_rect_g = Math.floor((Math.random() * 255));
      this.spawn_rect_b = Math.floor((Math.random() * 255));
    	this.spawn_x = x;
    	this.spawn_y = y;
      this.queue_it++;
  
    },
    
    renderMe: function(){     
    
      var MAP_SIZE = 600;
      var LEFT_COLUMN_WIDTH = 120;
      var RIGHT_COLUMN_WIDTH = 120;
      var TILES = MAP_SIZE / TILE_SIZE;
      var CANVAS_SIZE = 860;  
      var MAP_OFFSET = 130;
      var MAP_END = 600 + 130;
           	
      // vykreslenie siete
      this.context.clearRect(0,0,CANVAS_SIZE,MAP_SIZE);
      this.context.beginPath();
      this.context.lineWidth = 3;
      this.context.strokeStyle = 'black';
      this.context.rect(MAP_OFFSET,0,MAP_SIZE,MAP_SIZE);
      this.context.stroke();
      
      this.context.beginPath();
      this.context.lineWidth = 3;
      this.context.strokeStyle = 'blue';
      this.context.rect(MAP_END + 10 ,0 ,RIGHT_COLUMN_WIDTH,MAP_SIZE);
      this.context.stroke();
      
      this.context.beginPath();
      this.context.strokeStyle = 'red';
      this.context.rect(0,0,LEFT_COLUMN_WIDTH,MAP_SIZE);
      this.context.stroke();
      
      for(var i=1;i<TILES;i++){
        this.context.beginPath();
        this.context.lineWidth = 1;
        this.context.strokeStyle = "#000000";
        this.context.moveTo(MAP_OFFSET+i*TILE_SIZE, 0);
        this.context.lineTo(MAP_OFFSET+i*TILE_SIZE, MAP_SIZE);
        this.context.stroke();
        
        this.context.beginPath();
        this.context.strokeStyle = "#000000";
        this.context.moveTo(MAP_OFFSET,i*TILE_SIZE);
        this.context.lineTo(MAP_OFFSET+MAP_SIZE,i*TILE_SIZE);
        this.context.stroke();      
      }
      // vykreslenie objektov 
      this.drawSnake();
      this.drawSpawn();
      this.drawQueue();
      this.drawTrash();
      this.drawStateSpecific();
    
    
    },
    
    drawStateSpecific: function(){
      if (this.game_state == GAME_STATE_RUNNING || this.game_state == GAME_STATE_READING){
    	  this.drawScore(MAP_OFFSET+MAP_SIZE/2-110,30,2);    	  
      }
      
      if (this.game_state == GAME_STATE_READING){
    	  this.drawReading();   	  
      }
      
      if (this.game_state == GAME_STATE_READY){
    	  this.context.font="6em Arial";
    	  this.context.fillText("Pripraveny!",MAP_OFFSET+10 , 90); 
      }
      
      if (this.game_state == GAME_STATE_PAUSED){
    	  this.context.font="6em Arial";
    	  this.context.fillText("PAUZA", MAP_OFFSET+10 , 90); 
          this.context.fillText("BODY:"+this.score, MAP_OFFSET+10 , 90+120); 
      }
      
      if (this.game_state == GAME_STATE_ENDED){
    	  this.context.font="6em Arial";
    	  this.context.fillText("KONIEC", MAP_OFFSET+10 , 90);
    	  this.context.fillText("BODY:"+this.score, MAP_OFFSET+10 , 90+120);  
      } 
    },
    
    drawTrash: function(){
      var k = this.letter_trash.length;
       
      for (var i = 0; i<k ;i++){         
        this.context.beginPath();
        this.context.lineWidth = 2;      
        this.context.strokeStyle="black";
        this.context.fillStyle = "white";
       
    
        //console.log("j "+j);
        if (i<10){        
           this.context.rect(6,(9-i%10)*TILE_SIZE+6, TILE_SIZE - 12, TILE_SIZE - 12);         
        } else {
           this.context.rect(6+TILE_SIZE,(9-i%10)*TILE_SIZE+6, TILE_SIZE - 12, TILE_SIZE - 12);
        }
       
        
        this.context.stroke();
    
     	this.context.fillStyle = "#000000";
  	    this.context.font="2em Arial";   
                 

        var textString = this.letter_trash[i].toUpperCase();
        var textWidth = this.context.measureText(textString ).width;
        
        if (i<10){
           this.context.fillText(textString,(TILE_SIZE / 2)-(textWidth / 2),(10-i%10)*TILE_SIZE-17); 
        } else {
           this.context.fillText(textString,(TILE_SIZE / 2)-(textWidth / 2)+TILE_SIZE,(10-i%10)*TILE_SIZE-17); 
        }    
      }  
    },
    
    drawQueue: function(){  
      var k = this.letter_queue.length - this.queue_it;
     
      this.context.beginPath();
      this.context.lineWidth = 3;      
      this.context.strokeStyle="green";
      this.context.moveTo(MAP_END+10+30, 2);
    
      var k2= k>9?9:k-1;
      this.context.lineTo(MAP_END+10+30, k2*(TILE_SIZE)+6);
     
      if (k>10){
           this.context.moveTo(MAP_END+TILE_SIZE, 10*(TILE_SIZE)-(TILE_SIZE/2));
           this.context.lineTo(MAP_END+20+TILE_SIZE, 10*(TILE_SIZE)-(TILE_SIZE/2));
      }
      
      if (k>11){
           var k2 = k - 11;
           this.context.moveTo(MAP_END+10+90, 9*(TILE_SIZE)+6);
           this.context.lineTo(MAP_END+10+90, (9-k2)*(TILE_SIZE)+6);
      }

      this.context.stroke();          
  
      for (var i = 0; i<k ;i++){         
        this.context.beginPath();
        this.context.lineWidth = 2;      
        this.context.strokeStyle="black";
        this.context.fillStyle = "white";
       
        if (i<10){        
           this.context.fillRect(MAP_END+10+6,i*TILE_SIZE+6, TILE_SIZE - 12, TILE_SIZE - 12);
           this.context.strokeRect(MAP_END+10+6,i*TILE_SIZE+6, TILE_SIZE - 12, TILE_SIZE - 12);  
        } else {
           this.context.fillRect(MAP_END+10+6+60,(9-i%10)*TILE_SIZE+6, TILE_SIZE - 12, TILE_SIZE - 12);
           this.context.strokeRect(MAP_END+10+6+60,(9-i%10)*TILE_SIZE+6, TILE_SIZE - 12, TILE_SIZE - 12);
        }
       
        
        this.context.stroke();
    
     	this.context.fillStyle = "#000000";
  	    this.context.font="2em Arial";            
        var char = this.letter_queue[i+this.queue_it] + "";
        var textString = char.toUpperCase();
        var textWidth = this.context.measureText(textString ).width;
        
        if (i<10){
           this.context.fillText(textString,MAP_END+10+(TILE_SIZE / 2)-(textWidth / 2),(i+1)*TILE_SIZE-17); 
        } else {
           this.context.fillText(textString,MAP_END+10+(TILE_SIZE / 2)-(textWidth / 2)+60,(10-i%10)*TILE_SIZE-17); 
        }
      }   
    },
  
    drawScore: function(x,y,size){
        this.context.fillStyle = "#000000";
	    this.context.font=size+"em Arial";
	    var text = "BODY: "+this.score;
	    this.context.fillText(text,x,y);
    },
    
    drawReading: function(){

      var size = 200;
      var x = MAP_SIZE/2;
  	  var y = MAP_SIZE/2;
  	  
  	  this.context.fillStyle="#FFFFFF";
  	  if (this.ticks_left == 0){
  		  if (this.answer == true)
  			this.context.fillStyle="#00FF00";
  		  else if (this.answer == false)
  			this.context.fillStyle="#FF0000";
  		  
  	  }
  	  this.context.strokeRect(MAP_OFFSET+x- size/2,y- size/2,size,size);
  	  this.context.fillRect(MAP_OFFSET+x- size/2,y- size/2,size,size);
  	 
  	  this.context.fillStyle = "#000000";
	  this.context.font="8em Arial";
      
	  var char = this.spawn_letter + "";
	  var textString = char.toUpperCase();
      var textWidth = this.context.measureText(textString ).width;
	  
	  this.context.fillText(textString,MAP_OFFSET+ x - (textWidth / 2), y + size / 4);
    	
    },
  
    drawSpawn: function(){
      if (this.spawn_x==-1)
    		return;  
  	  
  	  this.context.beginPath();
      this.context.lineWidth = 2;      
      this.context.strokeStyle="rgb("+ this.spawn_rect_r+","+ this.spawn_rect_g +","+this.spawn_rect_b+")";
      this.context.rect(MAP_OFFSET+(this.spawn_x* TILE_SIZE)+6,(this.spawn_y* TILE_SIZE)+6, TILE_SIZE - 12, TILE_SIZE - 12);
      this.context.stroke();
  	 
  	  this.context.fillStyle = "#000000";
	  this.context.font="2em Arial";
        
  	  var char = this.spawn_letter + "";
  	  var textString = char.toUpperCase(),
  	  textWidth = this.context.measureText(textString ).width;
  	  
  	  this.context.fillText(textString,MAP_OFFSET+(this.spawn_x* TILE_SIZE)+(TILE_SIZE / 2)-(textWidth / 2),((this.spawn_y+1)* TILE_SIZE)-17);    	
    },
  
    drawSnake: function(){
    	
      var image=image_tail;
      this.context.fillStyle = "#000000";
  	  this.context.font="1.5em Arial";   
       
      for (var i = 1; i<this.snake_x.length;i++){  		
          this.context.drawImage(image,MAP_OFFSET+(this.snake_x[i]* TILE_SIZE)+1,(this.snake_y[i]* TILE_SIZE)+1);

        var textString = this.tail_letter[i].toUpperCase(),
        textWidth = this.context.measureText(textString ).width;

      //this.context.fillText(textString,MAP_END+10+(TILE_SIZE / 2)-(textWidth / 2),(i+1)*TILE_SIZE-12); 
      var x = MAP_OFFSET+(this.snake_x[i]* TILE_SIZE)+1+(TILE_SIZE / 2)-(textWidth / 2);
      this.context.fillText(textString,x,(this.snake_y[i]+1)* TILE_SIZE - 22); 
      }
      // hlava podla otocenia
      if (this.head_state==HEAD_STATE_UP)
          image = image_head_up;
      if (this.head_state==HEAD_STATE_DOWN)
          image = image_head_down;
      if (this.head_state==HEAD_STATE_LEFT)
          image = image_head_left;
      if (this.head_state==HEAD_STATE_RIGHT)
          image = image_head_right;



      this.context.drawImage(image,MAP_OFFSET+(this.snake_x[0] * TILE_SIZE)+1,(this.snake_y[0] * TILE_SIZE)+1);
    	
    },

    startLoop: function(){
      this.update();     
	  this.renderMe();	
	  setInterval(tick, UPDATE_RATE);
    },
  
    restart: function(){
      this.game_state = 0;
      this.head_state =  0;
      this.snake_x = [5];
      this.snake_y = [5];
      this.tail_letter = ['h'];
    
      this.letter_queue = [];
      this.queue_it = 0;
      this.letter_trash = [];
      var i = 0;
      while(i<GAME_LENGTH){
          var let = this.letters[Math.floor((Math.random() * this.letters.length))];
      
          if (UNIQUE){
            while(this.letter_queue.indexOf(let,0)!=-1){
              let = this.letters[Math.floor((Math.random() * this.letters.length))];
            } 
          }
          this.letter_queue.push(let);
          
          i++;     
      }
    },
    setAnswer: function(x){
      console.log("dostla som "+x);
      this.answer=x;
      stats[0]++;
      if(x)
        stats[1]++
      else
        stats[2]++;
	
    } 
  
};

function tick(){
  if (game.game_state == GAME_STATE_RUNNING || game.game_state == GAME_STATE_READING ){
    game.update();	  
  }
  game.renderMe();	
}
