var audio_api_state = null;
var audio_api_upload_state = null;

var AUDIO_API_STATE_IDLE = 0,
    AUDIO_API_STATE_RECORDING = 1;
  
var attemptNumber = att; // dostaneme!!! 

// Workers 

var mfccWorker = new Worker("javascript_workers/mfccWorker.js");
var resamplingWorker =  new Worker("javascript_workers/resamplingWorker.js");

// Recording and testing related

var currentUploadIteration;
var numberOfIterationsNeeded;

var testedLetter = null;


var recording_background = true;
var backgroundModels; //= []; ulozene modely pozadi na porovnavanie
var vectorsEnergy = []; // len pre ticho

var isSectionBackground = []; // background alebo len ticho 

var datalength100ms;
var sampleRate;

var context;


// x v sekundach * 10  1 sek -> x = 10


var lastBufferCut = 1; 
function getUploadCount(x){
  var oneMSData = sampleRate / 1000; 
  var res= (oneMSData * x) / 16384; //4096
  var r =0;
 // console.log("res",res);
  if (res != ~~(res)){
    r = ~~(res);
    res = (  ~~(  (res - ~~(res))*10 +1  )  )/10; 
    lastBufferCut = res;
  }
  //console.log("count ", r);
 // console.log("cast",lastBufferCut);
  //res = ~~(res);
  return r+1;  
}


function audioApiSetup(){
    console.log("audio start");
    context = new AudioContext() || new webkitAudioContext(); 
    
    navigator.getUserMedia = ( navigator.getUserMedia ||
                       navigator.webkitGetUserMedia ||
                       navigator.mozGetUserMedia ||
                       navigator.msGetUserMedia);
                       
    var audioNode = context.createScriptProcessor(16384, 1, 1); //4096 


    currentUploadIteration = 0;
   
    sampleRate = context.sampleRate; 
    console.log("sample rate: "+sampleRate);
    numberOfIterationsNeeded = getUploadCount(BACKGROUND_RECORD_TIME);  
  
    sendConfigMessageToResamplingWorker(resamplingWorker,WINDOW_LENGTH,sampleRate,NEW_SAMPLE_RATE);

    

    audioNode.onaudioprocess = function(audioProcessingEvent) {      

        var inputBuffer = audioProcessingEvent.inputBuffer;
    
        if (audio_api_upload_state == AUDIO_API_STATE_RECORDING){
             
             if (currentUploadIteration == 0 && !recording_background){
                backgroundModels = []; 
                //var l = Object.keys(models).length;
                //idem nahravat modely treba ulozit
                for (var i in models){
                  if (backgroundModels.length > 10)
                    break;
                  backgroundModels.push(models[i]);
                 
                }
             }
             var last = false;
             if (currentUploadIteration == numberOfIterationsNeeded -1){
               last = true;
             }
          
             if (last){
               var buffer = inputBuffer.getChannelData(0);
               var length = ~~(buffer.length * lastBufferCut) +1;
               var nbuffer = [];
               for (var i = 0; i < length; i++){
                 nbuffer.push(buffer[i]);                 
               }
               resamplingWorkerHandler(resamplingWorker, nbuffer, last);                 
             } else {
               resamplingWorkerHandler(resamplingWorker, inputBuffer.getChannelData(0), last);  
             }
	          
	         if (currentUploadIteration<numberOfIterationsNeeded){
		          currentUploadIteration++; 
	         } 
	         if (currentUploadIteration==numberOfIterationsNeeded) {
	        	currentUploadIteration = 0;
	            audio_api_upload_state = AUDIO_API_STATE_IDLE	
	         }
        }      
        
    };
  
    navigator.getUserMedia( {audio: true}, function(stream) {
    	console.log("bb");
        var microphone = context.createMediaStreamSource(stream);      
        microphone.connect(audioNode);
        audioNode.connect(context.destination);
        
        // test
        context.oncomplete= function(e){
          console.log("audio context skoncil");
          console.log(e);
        }
                   
      }, function(text){console.log("Error "+text);});
    
}  


function onError(text) {
  console.log("Error "+text);
}

function newStart(){
  audio_api_state = AUDIO_API_STATE_IDLE 
  audio_api_upload_state = AUDIO_API_STATE_IDLE;
  
  try {
    audioApiSetup(); 
  } catch (err){
    alert("WEB audio api nie je podporovane");
    return;
  } 
  
  try {
    connect();
  } catch (err){
    alert("Nepodarilo sa pripojit k serveru");
    return;
  } 
  if (GAME_MODE==GAME_MODE_RECORD){
    audio_api_state = AUDIO_API_STATE_RECORDING;
    audio_api_upload_state = AUDIO_API_STATE_RECORDING;
  }
}

// treba?
function setState(newstate){
    audio_api_state = newstate;	
}

function setUploadState(newstate){
    audio_api_state = newstate;		
    audio_api_upload_state= newstate;	
}

function setTested(letter){
	testedLetter = letter;	
}



// ----------------------- HANDLERS
var allVectors = [];


function onGameModePlay(e){

    if (audio_api_state == AUDIO_API_STATE_RECORDING && !recording_background){
      
        if (e.data.it <= RECORD_LAST_ITERATION){
          var newVectors = [];
          for (var i = 0; i<12; i++){
            newVectors.push(e.data.result[i]);
          }

          vectorsEnergy.push(e.data.energy);          
          allVectors.push(newVectors);
        } 
      

        if (e.data.it> RECORD_OFFSET / WINDOW_LENGTH){
         
        }
   
        if (e.data.it==RECORD_LAST_ITERATION){      
            var answer = testLetter(vectorsEnergy, allVectors, testedLetter);
            audio_api_state = AUDIO_API_STATE_IDLE;
            game.setAnswer(answer);
            if (SAVE_MFCC)
              sendMFCC({"mfcc":allVectors, "ticho":false, "id":attemptNumber});
            allVectors = [];
            vectorsEnergy = [];
        } 
    }
    if (audio_api_state == AUDIO_API_STATE_RECORDING && recording_background){
    
       if (e.data.it <= BACKGROUND_RECORD_LAST_ITERATION){
          var newVectors = [];
          for (var i = 0; i<12; i++){
            newVectors.push(e.data.result[i]);
          }

          vectorsEnergy.push(e.data.energy);          
          allVectors.push(newVectors);
      } 
     
      if (e.data.it == BACKGROUND_RECORD_LAST_ITERATION){
          recording_background = false;
          audio_api_state = AUDIO_API_STATE_IDLE;
          numberOfIterationsNeeded = getUploadCount(RECORD_TIME);
          if (SAVE_MFCC){
            sendMFCC({"mfcc":allVectors, "ticho":true, "id":attemptNumber}); // najprv poslat, riadok podtymto meni allVectors
          } 
          console.log("abc");
          initGameWithModel();         
          allVectors = [];
          vectorsEnergy = [];
      }
    }
  
}


var mfccWorkerHandler = function(worker, data, length, last){
        
  worker.onmessage = function(e){ 

    if (GAME_MODE == GAME_MODE_RECORD){
      onGameModeRecord(e);      
    }
    
    if (GAME_MODE == GAME_MODE_PLAY){
      onGameModePlay(e);      
    }

  };

  worker.postMessage({
      'data': data,
      'size': length,
      'last': last
  });
};

var config_message = true;
var sendConfigMessageToResamplingWorker = function(worker, window_length, oldSampleRate, newSampleRate){
  worker.postMessage({
      'window': window_length,
      'oldRate': oldSampleRate,
      'newRate': newSampleRate    
  });  
}



var packetPackId = 0; // id celej nahravky
var packedId = 0;  // kolkaty je v ramci packu
var resamplingWorkerHandler = function(worker, inputData, isLast){        
    
    worker.onmessage = function(e){
        if (e.data.isBuffer){        
            if (e.data.last){
              
               var message = { 'buffer':e.data.buffer, 
                               'last': e.data.last, 
                               'id': attemptNumber, 
                               'ticho': recording_background,
                               'safeMfcc': SAVE_MFCC,
                               'window': WINDOW_LENGTH,
                               'tested': testedLetter,
                               'packedId': packedId,
                               'packedPackId': packetPackId 
                             }
               packetPackId++;
               packedId = 0;
            } else {
               var message = {  'buffer':e.data.buffer, 
                                'last': e.data.last, 
                                'id': attemptNumber, 
                                'ticho': recording_background,
                                'safeMfcc': SAVE_MFCC,
                                'packedId': packedId,
                                'packedPackId': packetPackId 
                              }
               packedId++;
              
            }
            if (SAVE_RAW)
              sendRecord(message);        
          
        } else {
            // last = posledne okno na spracovanie
            mfccWorkerHandler(mfccWorker, e.data.window, e.data.window.length, e.data.last);  
        }
             
    };
      
    worker.postMessage({
        'data': inputData,
        'last': isLast
    });
};


function onGameModeRecord(e){
  if (e.data.it % 8 == 0)
      console.log("iteracia "+e.data.it+" "+e.data.energy);

    if (audio_api_state == AUDIO_API_STATE_RECORDING && !recording_background){
      
        if (e.data.it <= RECORD_LAST_ITERATION){
          var newVectors = [];
          for (var i = 0; i<12; i++){
            newVectors.push(e.data.result[i]);
          }

          vectorsEnergy.push(e.data.energy);          
          allVectors.push(newVectors);
        } 
      
        var vysledky = [];
        if (e.data.it> RECORD_OFFSET / WINDOW_LENGTH){
          if (e.data.it==~~(RECORD_OFFSET / WINDOW_LENGTH + 1)){
            isSectionBackground = [];
            for (var i=0; i<backgroundModels.length;i++){        
              isSectionBackground.push([]);
            }
          }

          for (var i=0; i<backgroundModels.length;i++){        
            var result = jeToTicho(newVectors,backgroundModels[i]); 
            isSectionBackground[i].push(result);
            //str += i+": "+result+" ";
          }
          //console.log(str);
        }
        // --------------------------------------- test ci sa posle pri ==
        if (e.data.it==RECORD_LAST_ITERATION){    
            
            var allmax = [];
            for (var i=0; i<isSectionBackground.length;i++){  
              var bind = 0; //index startu neticha
              var bmax = 0; // dlzka neticha
              var max = 0;
              var ind = 0;
              var netichujeme = false;
              for (var j=0; j<isSectionBackground[i].length;j++){
                if (isSectionBackground[i][j]==true){
                  if (netichujeme){
                    if (max>bmax){
                      bmax = max;
                      bind = ind;
                    }
                    max = 0;
                    netichujeme = false;
                  }                  
                } else{
                  if (netichujeme){
                    max++;
                  } else {
                    ind = j;
                    max++;
                    netichujeme = true;
                  }
                }             
              }
              allmax.push({'ind':bind,'len':bmax});                  
            }
            //console.log(allmax);
            var maxres = [];
            for (var i = 0; i < isSectionBackground[0].length; i++){
              maxres[i]=0;
            }
            for (var i = 0; i < allmax.length; i++){
              if (allmax[i].len>5){ 
                maxres[allmax[i].ind]++;
              }
            }
            //console.log(allmax);

            var answer = false;

            // pozrieme sa kde sa zacinaju najvecsie useky hovorenia, odchylka -+1, ak je tych vyskytov aspon /3 tak true
            var i = 0;
            for (i; i < maxres.length; i++){
              var t = maxres[i];
              if (i>0)
                t = t+ maxres[i-1];
              if (i<maxres.length-1)
                t = t+ maxres[i+1];
              if (t>= isSectionBackground.length/3){
                answer=true;
              }
            }
            //console.log(maxres);

            audio_api_state = AUDIO_API_STATE_IDLE;
            game.setAnswer(answer);
            if (SAVE_MFCC)
              sendMFCC({"mfcc":allVectors, "ticho":false, "id":attemptNumber});
            allVectors = [];
            vectorsEnergy = [];
        } 
    }
    if (audio_api_state == AUDIO_API_STATE_RECORDING && recording_background){
      
      
       if (e.data.it <= BACKGROUND_RECORD_LAST_ITERATION){
          var newVectors = [];
          for (var i = 0; i<12; i++){
            newVectors.push(e.data.result[i]);
          }

          vectorsEnergy.push(e.data.energy);          
          allVectors.push(newVectors);
      } 
     
      if (e.data.it == BACKGROUND_RECORD_LAST_ITERATION){
          recording_background = false;
          audio_api_state = AUDIO_API_STATE_IDLE;
          numberOfIterationsNeeded = getUploadCount(RECORD_TIME);
          if (SAVE_MFCC){
            sendMFCC({"mfcc":allVectors, "ticho":true, "id":attemptNumber}); // najprv poslat, riadok podtymto meni allVectors
          }
          sendTicho(modelujTicho(allVectors, RECORD_OFFSET / WINDOW_LENGTH, allVectors.length, vectorsEnergy)); 
          initGameWithModel(); // presunut? po prijati          
          allVectors = [];
          vectorsEnergy = [];
      }
    }
  
}

  



