var new_rate;
var window_length_in_ms;
var oldRate;

var windowDataLength;
var windowDataLengthWithZeros; // fourier needs array.lenght to be power of two
var first = true;
var resamplingRatio;
var createdWindow = []; // ine meno?


self.onmessage = function(e){
    if (first){
        // nazaciatku dostaneme config!
        window_length_in_ms = e.data.window; 
        new_rate = e.data.newRate;
        oldRate = e.data.oldRate;
      
        resamplingRatio = oldRate / new_rate; 
        // (rate nam udava za jednu sekundu, chceme len pre jedno okienko a to az po presamplovani
        windowDataLength = Math.floor(oldRate / (1000 / window_length_in_ms) / resamplingRatio);
        windowDataLengthWithZeros = closestPowerOfTwo(windowDataLength);
        console.log("windowLength " + windowDataLength);        
        first = false;
        return;
    }
      
    var inputDataLength = e.data.data.length;
    var inputData = e.data.data;

    // pocitat energiu pred samplovanim, alebo staci po a teda v mfccWorker-y
    
    var resampledDataNotNormalized = resampleData(inputData, inputDataLength, resamplingRatio);
    var resampledData = normalizeData(resampledDataNotNormalized);  
    var bufferInt16LE = floatArrayTo16IntBuffer(resampledData);
    
    self.postMessage({
        'isBuffer': true,
        'buffer': bufferInt16LE,
        'last': e.data.last
    }); 
  
 //console.log(resampledData.length);
    for (var i = 0; i < resampledData.length; i++){
        if (createdWindow.length >= windowDataLength){
            // urob buffer a odosli a prehod okna
           
            var outputWindow = addLittleNoiseAndZeros(createdWindow);  
            
            // nove okno bude obsahovat druhu polku predchadzajuceho
            var tmpArr = createdWindow;
            createdWindow = [];
            for (var j = 0; j < tmpArr.length / 2; j++){
              createdWindow.push(tmpArr[j + tmpArr.length / 2]);  
            }
            var last = false;
            if (e.data.last){
                // data.length + zvysok dat < treba -> posledna it
                if (createdWindow.length + (resampledData.length - i) < windowDataLength){
                    last = true;  
                }
            }
            
            self.postMessage({
              'isBuffer': false, 
              'window': outputWindow,
              'last': last
            }); 

        }
      
        createdWindow.push(resampledData[i]);    
    }
  
    if (e.data.last){
        createdWindow = [];
    } 
}; 



// --------- Functions -------------------

function closestPowerOfTwo(v){
    v--;
    v |= v >> 1;
    v |= v >> 2;
    v |= v >> 4;
    v |= v >> 8;
    v |= v >> 16;
    v++;
    return v;
}

// ked vytvarame 16int data, tak po nasobeni floorovanim menime trochu hodnotu
// takze treba upravit data aby sme mali rovnake ulozene a spracovavane 
function normalizeData(data){
    var resultData = [];

    for (var i = 0; i < data.length ;i++){
        // aby sme ukladali tie iste data co budeme pouzivat
        if (data[i]<0){
            data[i] = Math.floor(data[i] * 32768);
            data[i] = data[i] / 32768;            
        } else {
            data[i] = Math.floor(data[i] * 32767);
            data[i] = data[i] / 32767;
        }  
        resultData.push(data[i]);
    }
  
    return resultData;
  

  
} 
// chyba nasobenie a delenie a math.floor
function floatArrayTo16IntBuffer(data){
    // +2 pre hlavicku do spravy
    //var buffer = new Int16Array(data.length + 2);
   
    var buffer = new ArrayBuffer(data.length*2);
    var dataview = new DataView(buffer); 
  
    for (var i = 0; i < data.length ;i++){
        var sample16Int = data[i] < 0 ? (Math.floor(data[i] * 32768)) : (Math.floor(data[i] * 32767)); 

        // nemalo by nastat
        sample16Int = sample16Int > 32767 ? 32767 : sample16Int;
        sample16Int = sample16Int < -32768 ? -32768 : sample16Int;
        
        dataview.setInt16(i*2,sample16Int,true);
         
        
    }
    return buffer;
}

function addLittleNoiseAndZeros(data){
    var outputData = [];
    for (var i = 0; i < data.length; i++){
        outputData.push(data[i] + Math.random()/100000);
    }
  
    // aj nulam pridat sum? nie!
    for (var i = outputData.length; i < windowDataLengthWithZeros; i++){
        outputData.push(0);
    }
    return outputData;  
}


// treba skocit dalej
function resampleData(data, length, ratio){

  var i = 0,
      j = 0;
  var newData = [];  
  
  while (i < length){
    var k = Math.floor(i);
    var dec = i - k; 
    
    if (k == length - 1){
      newData[j] = data[k];
      i = length;
      j++;
      break;      
    }   
   
    newData[j]=(1 - dec)*data[k] + dec*data[k+1]; 
    i += ratio;
    j++; 
  }
  
  return newData;
}

