unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, uDelaunay, StdCtrls, ExtCtrls, Menus, ComCtrls, uStereo, ExtDlgs,
  Spin, uPlachta, uFarby;

type
  TForm1 = class(TForm)
    Image1: TImage;
    MainMenu1: TMainMenu;
    menu1: TMenuItem;
    exit1: TMenuItem;
    Body1: TMenuItem;
    miVymaz: TMenuItem;
    Image2: TImage;
    NacitajObrazokLoka: TMenuItem;
    NacitajObrazokRoka: TMenuItem;
    OpenPictureDialog1: TOpenPictureDialog;
    PageControl1: TPageControl;
    TabOfset: TTabSheet;
    TabKontrol: TTabSheet;
    DeleteButton: TButton;
    ChkLines: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    SpinEditX: TSpinEdit;
    SpinEditY: TSpinEdit;
    Label3: TLabel;
    EditBottom: TEdit;
    N1: TMenuItem;
    ChkFoto: TMenuItem;
    TabDrot: TTabSheet;
    GroupBox1: TGroupBox;
    XL: TButton;
    XR: TButton;
    YR: TButton;
    YL: TButton;
    ZR: TButton;
    ZL: TButton;
    plus: TButton;
    minus: TButton;
    ChkPersp: TCheckBox;
    ChkPloch: TCheckBox;
    ChkBinok: TCheckBox;
    ChkTransparent: TCheckBox;
    ChkSach: TCheckBox;
    TrackBar1: TTrackBar;
    Label4: TLabel;
    MenuFarby: TMenuItem;
    TabMapa: TTabSheet;
    BtnMapa: TButton;
    BtnDrot: TButton;
    nBodov: TSpinEdit;
    ChkSwap: TMenuItem;
    TabAnaglyf: TTabSheet;
    BtnDrotSave: TButton;
    SavePictureDialog1: TSavePictureDialog;
    BtnAnaSave: TButton;
    BtnAna: TButton;
    miZoomIn: TMenuItem;
    miZoomOut: TMenuItem;
    miZoom11: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    TabStereo: TTabSheet;
    BtnStereoSave: TButton;
    Label5: TLabel;
    SpinEditPadding: TSpinEdit;
    Label6: TLabel;
    Vymaz1: TMenuItem;
    EditRoz: TEdit;
    Label7: TLabel;
    EditTop: TEdit;
    Label8: TLabel;
    ChkSetBottom: TRadioButton;
    RadioButton2: TRadioButton;
    TabAutogram: TTabSheet;
    BtnAuto: TButton;
    BtnAutoSave: TButton;
    BtnMapaSave: TButton;
    procedure FormCreate(Sender: TObject);
    procedure miVymazClick(Sender: TObject);
    procedure KontrolMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure KontrolMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure KontrolMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OfsetMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OfsetMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure DrotMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure DrotMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure IbaHybMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure IbaHybMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure exit1Click(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure NacitajObrazok(Sender: TObject);
    procedure OptionChng(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure SpinEditXChange(Sender: TObject);
    procedure SpinEditYChange(Sender: TObject);
    procedure XRClick(Sender: TObject);
    procedure XLClick(Sender: TObject);
    procedure YRClick(Sender: TObject);
    procedure ZRClick(Sender: TObject);
    procedure YLClick(Sender: TObject);
    procedure ZLClick(Sender: TObject);
    procedure plusClick(Sender: TObject);
    procedure minusClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure MenuFarbyClick(Sender: TObject);
    procedure BtnDrotClick(Sender: TObject);
    procedure ChkSwapClick(Sender: TObject);
    procedure BtnDrotSaveClick(Sender: TObject);
    procedure BtnAnaClick(Sender: TObject);
    procedure BtnAnaSaveClick(Sender: TObject);
    procedure BtnMapaClick(Sender: TObject);
    procedure miZoomInClick(Sender: TObject);
    procedure miZoomOutClick(Sender: TObject);
    procedure miZoom11Click(Sender: TObject);
    procedure BtnStereoSaveClick(Sender: TObject);
    procedure BtnAutoClick(Sender: TObject);
    procedure BtnAutoSaveClick(Sender: TObject);
    procedure BtnMapaSaveClick(Sender: TObject);
  private
    imageMD: array [0..6] of TMouseEvent; {down}
    imageMM: array [0..6] of TMouseMoveEvent; {move}
    imageMU: array [0..6] of TMouseEvent; {up}
    RightDownX, RightDownY, MiddleDownSel: integer;
    RightDownImg: TObject;
    stereo: TStereogram;
    plachta: TPlachta;
    procedure PlaceImages;
    procedure DrawImages;
    procedure KresliPlachtu;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


procedure TForm1.FormCreate(Sender: TObject);
begin
  doublebuffered:= true;
  stereo:= TStereogram.Create(image1, image2);
  plachta:= TPlachta.Create(Image2.Canvas);
  plachta.xs:= Image2.Width div 2;
  plachta.ys:= Image2.Height div 2;
  KresliPlachtu;
  ImageMD[0]:= OfsetMouseDown;
  ImageMU[0]:= nil;
  ImageMM[0]:= OfsetMouseMove;
  ImageMD[1]:= KontrolMouseDown;
  ImageMU[1]:= KontrolMouseUp;
  ImageMM[1]:= KontrolMouseMove;
  ImageMD[2]:= IbaHybMouseDown;
  ImageMU[2]:= nil;
  ImageMM[2]:= IbaHybMouseMove;
  ImageMD[3]:= IbaHybMouseDown;
  ImageMU[3]:= DrotMouseUp;
  ImageMM[3]:= DrotMouseMove;
  ImageMD[4]:= IbaHybMouseDown;
  ImageMU[4]:= nil;
  ImageMM[4]:= IbaHybMouseMove;
  ImageMD[5]:= IbaHybMouseDown;
  ImageMU[5]:= nil;
  ImageMM[5]:= IbaHybMouseMove;
  ImageMD[6]:= IbaHybMouseDown;
  ImageMU[6]:= nil;
  ImageMM[6]:= IbaHybMouseMove;
  PageControl1.OnChange(Sender);
end;

procedure TForm1.PlaceImages;
var temp: integer;
begin
  if (chkSwap.Checked) = (Image1.Left < Image2.Left) then begin
    temp:= Image1.Left;
    Image1.Left:= Image2.Left;
    Image2.Left:= temp;
  end
end;

procedure TForm1.DrawImages;
begin
  if PageControl1.ActivePage = TabOfset then
    stereo.Vykresli(true, false, false, ChkFoto.Checked);
  if PageControl1.ActivePage = TabKontrol then
    stereo.Vykresli(false, true, ChkLines.Checked, ChkFoto.Checked);
  if PageControl1.ActivePage = TabMapa then begin
    stereo.VykresliLFotku;
    stereo.VykresliMapu;
  end;
  if PageControl1.ActivePage = TabDrot then begin
    stereo.VykresliLFotku;
    KresliPlachtu;
  end;
  if PageControl1.ActivePage = TabAnaglyf then begin
    stereo.VykresliLFotku;
    stereo.VykresliAnaglyf;
  end;
  if PageControl1.ActivePage = TabStereo then
    stereo.Vykresli(false, false, false, true);
  if PageControl1.ActivePage = TabAutogram then begin
    stereo.VykresliLFotku;
    stereo.VykresliAuto;
  end;
end;

procedure TForm1.KresliPlachtu;
begin
  plachta.SetN(nBodov.Value);
  plachta.Kresli(
    ChkSach.Checked,
    ChkBinok.Checked,
    ChkPloch.Checked,
    ChkPersp.Checked,
    ChkTransparent.Checked);
end;

procedure TForm1.miVymazClick(Sender: TObject);
begin
  if application.MessageBox('Naozaj chces vymazat vsetky kontrolne body?', 'Iste?', MB_YESNO)
    = ID_YES
  then begin
    stereo.DeletePoints;
    DrawImages;
  end;
end;

procedure TForm1.KontrolMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  case Button of
    mbRight: begin
      RightDownX:= X;
      RightDownY:= Y;
      RightDownImg:= Sender;
    end;
    mbMiddle: begin
      if Sender = Image2
      then MiddleDownSel:= stereo.SelectByRXY(X, Y)
      else MiddleDownSel:= stereo.SelectByLXY(X, Y);
      DrawImages;
    end;
    mbLeft: begin
      if Sender = Image2 then begin
        if stereo.SelectByRXY(X, Y) = -1
        then stereo.SelectByID(stereo.AddPoint(x,y, 0))
      end else begin
        if stereo.SelectByLXY(X, Y) = -1
        then stereo.SelectByID(stereo.AddPoint(x,y, stereo.GetMainShift(BOTTOM_POINT)));
      end;
      EditRoz.Text:= IntToStr(stereo.GetShift);
      DrawImages;
    end;
  end;
end;

procedure TForm1.KontrolMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  {Nema sa obsluhovat kazde tlacitko extra. Prave ma prednost.}
  if ssRight in Shift then begin
    if RightDownImg <> Sender then exit;
    stereo.MoveView(RightDownX-X, RightDownY-Y);
    {ked sa mys hybe doprava, v skutocnosti sa viewport hybe dolava}
    DrawImages;
    RightDownX:= X;
    RightDownY:= Y;
  end
  else if ssLeft in Shift then begin
    if sender = Image1
    then stereo.MoveSelected(x, y)
    else EditRoz.Text:= IntToStr(stereo.MoveShiftByX(x));
    DrawImages;
  end;
end;

procedure TForm1.KontrolMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  sel: integer;
begin
  case Button of
    mbMiddle: begin
      if Sender = Image2
      then Sel:= stereo.SelectByRXY(X, Y)
      else Sel:= stereo.SelectByLXY(X, Y);
      if MiddleDownSel = sel then begin
        stereo.DeleteSelected;
        DrawImages;
      end else stereo.SelectByID(MiddleDownSel);
    end
  end;
end;

procedure TForm1.OfsetMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  case Button of
    mbRight: begin
      RightDownX:= X;
      RightDownY:= Y;
      RightDownImg:= Sender;
    end;
    mbLeft: begin
      if ChkSetBottom.Checked then
        if Sender = Image1
        then stereo.MoveMain(BOTTOM_POINT, X, Y)
        else EditBottom.Text:= IntToStr(stereo.MoveMainShiftByX(BOTTOM_POINT, X))
      else
        if Sender = Image1
        then stereo.MoveMain(TOP_POINT, X, Y)
        else EditTop.Text:= IntToStr(stereo.MoveMainShiftByX(TOP_POINT, X));
      DrawImages;
    end;
  end;
end;

procedure TForm1.OfsetMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  {Nema sa obsluhovat kazde tlacitko extra. Prave ma prednost.}
  if ssRight in Shift then begin
    if RightDownImg <> Sender then exit;
    stereo.MoveView(RightDownX-X, RightDownY-Y);
    {ked sa mys hybe doprava, v skutocnosti sa viewport hybe dolava}
    DrawImages;
    RightDownX:= X;
    RightDownY:= Y;
  end
  else if ssLeft in Shift then begin
    if ChkSetBottom.Checked then
      if Sender = Image1
      then stereo.MoveMain(BOTTOM_POINT, X, Y)
      else EditBottom.Text:= IntToStr(stereo.MoveMainShiftByX(BOTTOM_POINT, X))
    else
      if Sender = Image1
      then stereo.MoveMain(TOP_POINT, X, Y)
      else EditTop.Text:= IntToStr(stereo.MoveMainShiftByX(TOP_POINT, X));
    DrawImages;
  end;
end;

procedure TForm1.DrotMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  {Nema sa obsluhovat kazde tlacitko extra. Prave ma prednost.}
  if ssRight in Shift then begin
    if RightDownImg <> Sender then exit;
    if RightDownImg = Image1 then begin
      stereo.MoveView(RightDownX-X, RightDownY-Y);
      stereo.VykresliLFotku;
    end else begin
      plachta.xs:= plachta.xs + X - RightDownX;
      plachta.ys:= plachta.ys + Y - RightDownY;
      plachta.Kresli(
        ChkSach.Checked,
        ChkBinok.Checked,
        false,                 {pocas hybania, iba ciarami}
        ChkPersp.Checked,
        ChkTransparent.Checked);
    end;
    RightDownX:= X;
    RightDownY:= Y;
  end;
end;

procedure TForm1.DrotMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbRight) and (Sender = Image2) then
    KresliPlachtu;
end;

procedure TForm1.IbaHybMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  case Button of
    mbRight: begin
      RightDownX:= X;
      RightDownY:= Y;
      RightDownImg:= Sender;
    end;
  end;
end;

procedure TForm1.IbaHybMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  {Nema sa obsluhovat kazde tlacitko extra. Prave ma prednost.}
  if ssRight in Shift then begin
    if RightDownImg <> Sender then exit;
    stereo.MoveView(RightDownX-X, RightDownY-Y);
    RightDownX:= X;
    RightDownY:= Y;
    DrawImages;
  end;
end;

procedure TForm1.exit1Click(Sender: TObject);
begin
  application.Terminate;
end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
  Image1.OnMouseDown:= ImageMD[PageControl1.ActivePageIndex];
  Image2.OnMouseDown:= ImageMD[PageControl1.ActivePageIndex];
  Image1.OnMouseMove:= ImageMM[PageControl1.ActivePageIndex];
  Image2.OnMouseMove:= ImageMM[PageControl1.ActivePageIndex];
  Image1.OnMouseUp:= ImageMU[PageControl1.ActivePageIndex];
  Image2.OnMouseUp:= ImageMU[PageControl1.ActivePageIndex];
  DrawImages;
end;

procedure TForm1.NacitajObrazok(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
    if Sender = NacitajObrazokLoka
    then stereo.LoadLeft(OpenPictureDialog1.FileName)
    else stereo.LoadRight(OpenPictureDialog1.FileName);
  DrawImages;
end;

procedure TForm1.OptionChng(Sender: TObject);
begin
  DrawImages;
end;

procedure TForm1.DeleteButtonClick(Sender: TObject);
begin
  stereo.DeleteSelected;
  DrawImages;
end;

procedure TForm1.SpinEditXChange(Sender: TObject);
begin
  try
    stereo.ofsetX:= SpinEditX.Value;
    DrawImages;
  except
    on EConvertError do exit;
  end;
end;

procedure TForm1.SpinEditYChange(Sender: TObject);
begin
  try
    stereo.ofsetY:= SpinEditY.Value;
    DrawImages;
  except
    on EConvertError do exit;
  end;
end;
           
procedure TForm1.XLClick(Sender: TObject);
begin
  with plachta do rotuj (zv, yv, z3dv, y3dv, UHOL);
  KresliPlachtu;
end;

procedure TForm1.XRClick(Sender: TObject);
begin
  with plachta do rotuj (yv, zv, y3dv, z3dv, UHOL);
  KresliPlachtu;
end;

procedure TForm1.YLClick(Sender: TObject);
begin
  with plachta do rotuj (xv, zv, x3dv, z3dv, UHOL);
  KresliPlachtu;
end;

procedure TForm1.YRClick(Sender: TObject);
begin
  with plachta do rotuj (zv, xv, z3dv, x3dv, UHOL);
  KresliPlachtu;
end;

procedure TForm1.ZLClick(Sender: TObject);
begin
  with plachta do rotuj (yv, xv, y3dv, x3dv, UHOL);
  KresliPlachtu;
end;

procedure TForm1.ZRClick(Sender: TObject);
begin
  with plachta do rotuj (xv, yv, x3dv, y3dv, UHOL);
  KresliPlachtu;
end;

procedure TForm1.plusClick(Sender: TObject);
begin
  plachta.Scale(NASOBOK);
  KresliPlachtu;
end;

procedure TForm1.minusClick(Sender: TObject);
begin
  plachta.Scale(1/NASOBOK);
  KresliPlachtu;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  plachta.rozostup:= TrackBar1.Position;
  KresliPlachtu;
end;

procedure TForm1.BtnDrotClick(Sender: TObject);
begin
  KresliPlachtu;
end;

procedure TForm1.MenuFarbyClick(Sender: TObject);
begin
  FarbyForm.Visible:= not FarbyForm.Visible;
end;

procedure TForm1.ChkSwapClick(Sender: TObject);
begin
  PlaceImages;
end;

procedure TForm1.BtnDrotSaveClick(Sender: TObject);
begin
  if SavePictureDialog1.Execute then
    Image2.Picture.SaveToFile(SavePictureDialog1.FileName);
end;

procedure TForm1.BtnAnaClick(Sender: TObject);
begin
  stereo.VytvorAnaglyf;
  stereo.VykresliAnaglyf;
end;

procedure TForm1.BtnAnaSaveClick(Sender: TObject);
begin
  if SavePictureDialog1.Execute then
    stereo.UlozAnaglyf(SavePictureDialog1.FileName);
end;

procedure TForm1.BtnMapaClick(Sender: TObject);
begin
  stereo.VytvorMapu;
  stereo.VykresliMapu;
end;

procedure TForm1.BtnMapaSaveClick(Sender: TObject);
begin
  if SavePictureDialog1.Execute then
    stereo.UlozMapu(SavePictureDialog1.FileName);
end;

procedure TForm1.miZoomInClick(Sender: TObject);
begin
  stereo.SetZoomMul(6/5, true);
  DrawImages;
end;

procedure TForm1.miZoomOutClick(Sender: TObject);
begin
  stereo.SetZoomMul(5/6, true);
  DrawImages;
end;

procedure TForm1.miZoom11Click(Sender: TObject);
begin
  stereo.SetZoom(1, true);
  DrawImages; 
end;

procedure TForm1.BtnStereoSaveClick(Sender: TObject);
var
  tmp, s1, s2: TBitmap;
  i, BytesPerLine: integer;
  Lpix, Rpix, pix: PByteArray;
  padding: integer;
begin
  if not SavePictureDialog1.Execute then exit;
  padding:= SpinEditPadding.Value;

  tmp:= TBitmap.Create;
  tmp.Height:= Image1.Height;
  tmp.Width:= Image1.Width * 2 + padding;
  BytesPerLine:= Image1.Width * 3;   //Prevedieme na byte-y
  padding:= padding * 3;             //Prevedieme na byte-y

  tmp.PixelFormat:= pf24bit;
  Image1.Picture.Bitmap.PixelFormat:= pf24bit;
  Image2.Picture.Bitmap.PixelFormat:= pf24bit;
  if ChkSwap.Checked then begin
    s1:= Image2.Picture.Bitmap;
    s2:= Image1.Picture.Bitmap;
  end else begin
    s1:= Image1.Picture.Bitmap;
    s2:= Image2.Picture.Bitmap;
  end;
  for i:= 0 to tmp.Height-1 do
  begin
    Lpix:= s1.ScanLine[i];
    Rpix:= s2.ScanLine[i];
    pix:= tmp.ScanLine[i];
    Move(Lpix^, pix^, BytesPerLine);
    FillChar(pix^[BytesPerLine], BytesPerLine, 0);
    Move(Rpix^, pix^[BytesPerLine+padding], BytesPerLine);
  end;
  tmp.SaveToFile(SavePictureDialog1.FileName);
  tmp.Free;
end;

procedure TForm1.BtnAutoClick(Sender: TObject);
begin    
  stereo.VytvorAuto;
  stereo.VykresliAuto;
end;

procedure TForm1.BtnAutoSaveClick(Sender: TObject);
begin
  if SavePictureDialog1.Execute then
    stereo.UlozAuto(SavePictureDialog1.FileName);
end;

end.
