unit uPlachta;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Spin, StdCtrls, ComCtrls, math, Menus, uFarby;

type
  Tcislo = double;
  Tvektor = record x, y: Tcislo end;
  T3dvektor = record x, y, z: Tcislo end;

  TPlachta = class
    public
      xs, ys: integer;
      x3dv, y3dv, z3dv: T3dVektor;
      xv, yv, zv: Tvektor;
      rozostup: integer;
      poradie: array of integer; //tu mame usporiadanie podla Z bufferu.
                          //medzi volaniami .kresli by sa malo zachovat
      koef: TCislo; //koeficient nasobenia Z suradnice;
      pole: array [0..500, 0..500] of TCislo;
      constructor Create(c: TCanvas);
      destructor Destroy; override;
      procedure SetN (v: integer);
      procedure ResetSuradnic;
      procedure Kresli(sachovnic, biokulkarne, plochami, perspektivne, BinokTransparent: boolean);
      procedure Scale(s: TCislo);
    private
      kde: array [0..500, 0..500] of TPoint;
      KresliSa: boolean;   //lock na zmenu n
      n, noveN: integer;   //pocet uzlov
      canvas: TCanvas;
      deldel: TCislo;
      xposun: integer; //pri biokularnom
  end;

procedure rotuj (var v1, v2: TVektor; var v3d1, v3d2: T3dVektor; fi: real);

const
  xvDef: TVektor = (x:100; y:  0);
  yvDef: TVektor = (x: 50; y: 50);
  zvDef: TVektor = (x:  0; y:100);
  x3dvDef: T3dVektor =(x: 1; y: 0; z: 0);
  y3dvDef: T3dVektor =(x: 0; y: 1; z: 0);
  z3dvDef: T3dVektor =(x: 0; y: 0; z: 1);
  NASOBOK = 6/5;
  UHOL    = (6/180)*pi;

implementation

constructor TPlachta.Create(c: TCanvas);
begin
  KresliSa:= false;
  n:= 0;
  noveN:= n;
  canvas:= c;
  xposun:= 0;
  koef:= 1;
  rozostup:= 20;
  ResetSuradnic;
end;

destructor TPlachta.Destroy;
begin
  SetLength(poradie, 0);
end;

procedure TPlachta.ResetSuradnic;
begin
  deldel:= 250;
  xv:= xvDef;
  yv:= yvDef;
  zv:= zvDef;
  x3dv:= x3dvDef;
  y3dv:= y3dvDef;
  z3dv:= z3dvDef;
end;

procedure TPlachta.SetN(v: integer);
//n sa nesmie zmenit pocas vykreslovania
var i: integer;
begin
  noveN:= v;
  if not KresliSa then begin
    n:= NoveN;
    SetLength (poradie, n*n);
    for i:= 0 to n*n - 1 do poradie[i]:= i;
  end;
end;

procedure TPlachta.Scale(s: TCislo);
begin  
  deldel:= deldel * s;
  xv.x:= xv.x * s;
  xv.y:= xv.y * s;
  yv.x:= yv.x * s;
  yv.y:= yv.y * s;
  zv.x:= zv.x * s;
  zv.y:= zv.y * s;
end;

{procedure TForm1.DajSur;
begin
  Image1.Canvas.pen.Color:= 200;
  Image1.Canvas.MoveTo (xs, ys);
  Image1.Canvas.LineTo (xs + round (xv.x), ys + round (xv.y));
  Image1.Canvas.MoveTo (xs, ys);
  Image1.Canvas.LineTo (xs + round (yv.x), ys + round (yv.y));
  Image1.Canvas.MoveTo (xs, ys);
  Image1.Canvas.LineTo (xs + round (zv.x), ys + round (zv.y));
end;}

procedure TPlachta.kresli(sachovnic, biokulkarne, plochami, perspektivne, BinokTransparent: boolean);
type T5bod = array [1..5] of TPoint;
var
  Farba1, Farba2: TColor;

  function s (var b: T5bod): integer; {dvojnasobny obsah trojuholnicka b[1,2,3]}
  begin
    s:= (b[2].x-b[1].x) * (b[3].y-b[1].y) - (b[2].y-b[1].y) * (b[3].x-b[1].x);
  end;

  procedure ciarami (farba: Tcolor);
  var i, j: integer;
  begin
    canvas.Pen.Color:= Farba;
    for i:= 0 to n do
    begin
      canvas.MoveTo (kde[i, 0].x, kde[i, 0].y);
      for j:= 1 to n do canvas.LineTo (kde[i, j].x, kde[i, j].y);
    end;
    for j:= 0 to n do
    begin
      canvas.MoveTo (kde[0, j].x, kde[0, j].y);
      for i:= 1 to n do canvas.LineTo (kde[i, j].x, kde[i, j].y);
    end;
  end;

  procedure plochami3D (farba, zotriet: Tcolor);
  var
    pole0, pole1, prior: array of TCislo;
    najprv: array of boolean;

    procedure DoboSort (k: integer);
    var
      gap, z, c, temp: integer;
    begin
      gap:= k;
      repeat
        c:= gap;
        for z:= 0 to k - gap do
        begin
          if prior[poradie[z]] > prior[poradie[c]] then
          begin
            temp:= poradie[z];
            poradie[z]:= poradie[c];
            poradie[c]:= temp;
          end;
          inc (c);
        end;
        gap:= (gap * 3) div 4;
      until gap = 0;
    end;

  var
    temp: T5bod;

    procedure zotieranie;
    begin
      if zotriet <> clBlack then begin
        canvas.brush.Color:= zotriet;
        canvas.Pen.Color:= zotriet;
        canvas.Pen.Mode:= pmMerge;  {orput}
        canvas.polygon (slice(temp, 3));
        canvas.Pen.Mode:= pmMask;   {andput}
      end;
    end;

  var
    i, j, index: integer;
    ypx, ypz, ypy, L0, L1, P0, P1: TCislo;
    pom: boolean;
    pd: TCislo;
  begin
    SetLength (prior,   n*n );
    SetLength (najprv,  n*n );
    SetLength (pole0,   n+1);
    SetLength (pole1,   n+1);
    {Do pola prior vyratame "hlbku"}
    pd:= n / 2;
    ypy:= y3dv.y / pd;
    ypx:= x3dv.y / pd;
    ypz:= z3dv.y * koef;
    for j:= 0 to n do pole0[j]:= j*ypy + pole[0, j]*ypz;
    index:=0;
    for i:= 1 to n do
    begin
      for j:= 0 to n do pole1[j]:= i*ypx + j*ypy + pole[i, j]*ypz;
      L0:= pole0[0];
      L1:= pole1[0];
      for j:= 0 to n - 1 do
      begin
        P0:= pole0[j+1];
        P1:= pole1[j+1];
        prior[index]:= L0+L1+P0+P1;
        najprv[index]:= L0 > P1;
        L0:= P0;
        L1:= P1;
        pole0[j]:= pole1[j];
        inc (index);
      end;
      pole0[n]:= pole1[n];
    end;
    {Zosortujeme podla hlbky}
    Dobosort (n*n-1);
    {vykreslujeme od najhlbsej}
    for index:= n*n-1 downto 0 do
    begin
      j:= poradie[index];
      pom:= najprv[j];
      i:= j div n;
      j:= j mod n;
      temp[1]:= kde[i,j+1];   {1, 3 = uhlopriecka}
      temp[3]:= kde[i+1,j];
      if pom then temp[2]:= kde[i,j] else temp[2]:= kde[i+1,j+1];
      zotieranie;
{kreslenie}
      if sachovnic
      then if odd(i+j)
        then canvas.brush.Color:= Farba1
        else canvas.brush.Color:= Farba2
      else if (s(temp)>0) xor pom
        then canvas.brush.Color:= Farba1
        else canvas.brush.Color:= Farba2;
      canvas.Pen.Color:= canvas.brush.Color;
      canvas.polygon (slice(temp, 3));
      temp[4]:= temp[2];
      if pom then temp[2]:= kde[i+1,j+1] else temp[2]:= kde[i,j];
      zotieranie;
{kreslenie}
      if sachovnic
      then if odd(i+j)
        then canvas.brush.Color:= Farba1
        else canvas.brush.Color:= Farba2
      else if (s(temp)<0) xor pom
        then canvas.brush.Color:= Farba1
        else canvas.brush.Color:= Farba2;
      canvas.Pen.Color:= canvas.brush.Color;
      canvas.polygon (slice(temp, 3));
{ciara okolo}
      temp[5]:= temp[1];
      canvas.Pen.color:= Farba;
      canvas.Polyline(temp);
    end;
  end;

  procedure pripravPara;
  var
    i, j: integer;
    xj, yj, zj: TVektor;
    pd: TCislo;
  begin
    zj.x:= zv.x * koef;
    zj.y:= zv.y * koef;
    pd:= n / 2;
    xj.x:= xv.x / pd;
    xj.y:= xv.y / pd;
    yj.x:= yv.x / pd;
    yj.y:= yv.y / pd;
    for i:= 0 to n do
      for j:= 0 to n do
      begin
        kde[i, j].x:= xs + round ((i-pd)*xj.x + (j-pd)*yj.x + pole[i, j]*zj.x);
        kde[i, j].y:= ys - round ((i-pd)*xj.y + (j-pd)*yj.y + pole[i, j]*zj.y);
      end;
  end;

  procedure priprav3D;
  var
    delitel: TCislo;
    i, j: integer;
    xj, yj, zj: T3DVektor;
    pd: TCislo;
  begin
    zj.x:= z3dv.x * koef;
    zj.y:= z3dv.y * koef;
    zj.z:= z3dv.z * koef;
    pd:= n / 2;
    xj.x:= x3dv.x / pd;
    xj.y:= x3dv.y / pd;
    xj.z:= x3dv.z / pd;
    yj.x:= y3dv.x / pd;
    yj.y:= y3dv.y / pd;
    yj.z:= y3dv.z / pd;
    for i:= 0 to n do
      for j:= 0 to n do
      begin
        delitel:= (3 + ((i-pd)*xj.y + (j-pd)*yj.y + pole[i, j]*zj.y))/deldel;
        kde[i, j].x:= xs + round (
          (xposun/250 + (i-pd)*xj.x + (j-pd)*yj.x + pole[i, j]*zj.x) / delitel);
        kde[i, j].y:= ys - round (
          ((i-pd)*xj.z + (j-pd)*yj.z + pole[i, j]*zj.z) / delitel);
      end;
  end;
var
  sxposun: integer;
  NotFarba: TColor;
begin
  if n = 0 then exit;
  KresliSa:= true;
  canvas.brush.Color:= Pozadie;
  canvas.FillRect(canvas.ClipRect);
  if biokulkarne then
  begin
    canvas.Pen.Mode:= pmMask;
    sxposun:= xposun;
    xposun:= sxposun - rozostup;
    Priprav3d;
    Farba1:= LavaSFarba;
    if sachovnic then Farba2:= Pozadie else Farba2:= LavaSFarba;
    if BinokTransparent then NotFarba:= LavaNotFarba else NotFarba:= clBlack;
    if plochami then plochami3D(LavaFarba, NotFarba) else ciarami (LavaFarba);
    xposun:= sxposun + rozostup;
    Priprav3d;
    Farba1:= PravaSFarba;
    if sachovnic then Farba2:= Pozadie else Farba2:= PravaSFarba;
    if BinokTransparent then NotFarba:= PravaNotFarba else NotFarba:= clBlack;
    if plochami then plochami3D(PravaFarba, NotFarba) else ciarami (PravaFarba);
    xposun:= sxposun; 
    canvas.Pen.Mode:= pmCopy;
  end else begin
    canvas.Pen.Mode:= pmCopy;
    Farba1:= HornaFarba;
    Farba2:= DolnaFarba;
    if perspektivne then priprav3d else pripravPara;
    if plochami
    then plochami3D(clBlack, clBlack)
    else ciarami (clBlack);
  end;
  KresliSa:= false;
  if NoveN <> n then SetN(NoveN);  //chcelo sa zmenit N pocas kreslenia?
end;

procedure rotuj (var v1, v2: TVektor; var v3d1, v3d2: T3dVektor; fi: real);
var
  n: TVektor;
  n3d: T3dVektor;
  sinus, kosinus: Extended;
begin
  sincos (fi, sinus, kosinus);
  n.x := kosinus * v1.x + sinus * v2.x;
  n.y := kosinus * v1.y + sinus * v2.y;
  v2.x:= kosinus * v2.x - sinus * v1.x;
  v2.y:= kosinus * v2.y - sinus * v1.y;
  v1:= n;
  n3d.x := kosinus * v3d1.x + sinus * v3d2.x;
  n3d.y := kosinus * v3d1.y + sinus * v3d2.y;
  n3d.z := kosinus * v3d1.z + sinus * v3d2.z;
  v3d2.x:= kosinus * v3d2.x - sinus * v3d1.x;
  v3d2.y:= kosinus * v3d2.y - sinus * v3d1.y;
  v3d2.z:= kosinus * v3d2.z - sinus * v3d1.z;
  v3d1:= n3d;
end;

end.
