#ifndef _MCL_MIKES_H_
#define _MCL_MIKES_H_

#include "lidar.h"
#include "astar.h"

#define HYPO_COUNT 1000
#define MAP_W 4578
#define MAP_H 4303
#define STATE_WIDTH 25
#define STATES_W ((MAP_W/STATE_WIDTH) + 1)
#define STATES_H ((MAP_H/STATE_WIDTH) + 1)

#define NUMBER_OF_VERTICES 163
#define NUMBER_OF_VERTICES_I 101
#define NUMBER_OF_VERTICES_A 49
#define NUMBER_OF_VERTICES_H 13

#define NORM_PROB_CONST 0.2

typedef struct {
  double x, y, alpha;
  double w;
} hypo_t;

typedef struct {
    double x;
    double y;
} point;

typedef struct {
   double x1;
   double y1;
   double x2;
   double y2;
   int id;
} line;

extern point poly_i[];
extern point poly_a[];
extern point poly_h[];
extern line lines[];
extern int world[];

int WorldAt(int x, int y);

void get_mcl_data(hypo_t *buffer);
int mcl_update(double traveled, int heading, lidar_data_type liddata);
double line_intersection(double x1, double y1, double x2, double y2,
                          double x3, double y3, double x4, double y4,
                          double *X, double *Y);
double get_min_intersection_dist(double x1, double y1, double alpha);
int get_line_intersection(double x1, double y1, double x2, double y2);
int init_world();
int init_mcl();


#endif
