#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "ride.h"
#include "astar.h"
#include "mikes_logs.h"
#include "mcl.h"

#define DESIRED_SQ 3

double get_desired_heading(pose_type pose)
{
	//mikes_log_val2(ML_DEBUG, "ride: pose.x pose.y", pose.x, pose.y);
	int desired_sq = DESIRED_SQ;
	if (path_len < DESIRED_SQ)
		desired_sq = path_len - 1;
	if (desired_sq == 0)
	{
		printf("desired sq = 0\n");
		return 0;
	}	
	//mikes_log_val(ML_DEBUG, "ride: desired sq", desired_sq);
	
	for (int i = 0; i < desired_sq; i++)
	{
		mikes_log_val2(ML_DEBUG, "ride: [sqx, sqy]", path[i][1], path[i][0]);
	}
	
	double goal_x = (path[desired_sq][1] * STATE_WIDTH + STATE_WIDTH / 2.0)*10; 
	double goal_y = (path[desired_sq][0] * STATE_WIDTH + STATE_WIDTH / 2.0)*10;
	
	//printf("ride: pose[%.1f, %.1f] goal[%.1f, %.1f]\n", pose.x, pose.y, goal_x, goal_y);
	
	double vector_x = goal_x - pose.x;
	double vector_y = goal_y - pose.y;
	double vector_len = sqrt(vector_x*vector_x + vector_y*vector_y);
	
	//printf("ride: vector(%.1f, %.1f) len = %.1f\n", vector_x, vector_y, vector_len);
	
	double robot_x = sin(pose.heading);
	double robot_y = -cos(pose.heading);
	double robot_len = sqrt(robot_x*robot_x + robot_y*robot_y);

	//printf("ride: robot(%.1f, %.1f) len = %.1f\n", robot_x, robot_y, robot_len);
	
	double heading_s = atan2(vector_y, vector_x) - atan2(robot_y, robot_x); //signed heading
	
	//printf("ride: heading %.1f\n", heading_s*180/M_PI);
	
	
	return heading_s;
}

void get_grid_location(pose_type pose)
{
	double min_dist2 = MAP_H + MAP_W;
	
	for (int i = 0; i < path_len; i++)
	{
		double vect_x = fabs(pose.x - (path[i][1]*STATE_WIDTH + (STATE_WIDTH / 2.0)));
		double vect_y = fabs(pose.y - (path[i][0]*STATE_WIDTH + (STATE_WIDTH / 2.0)));
		double dist2 = vect_x*vect_x + vect_y*vect_y;
		
		if (dist2 < min_dist2)
		{
			min_dist2 = dist2;
			sqx = path[i][1];
			sqy = path[i][0];
		}
	}
	//printf("ride: actual square (%d, %d) of pose[%.2f %.2f]\n", sqx, sqy, pose.x, pose.y);
}

