from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_migrate import Migrate
from config import Config
from .constant import TestingStatus, Language

app = Flask(__name__)
app.config.from_object(Config)
db = SQLAlchemy(app)
migrate = Migrate(app, db)

from app import routes, models


def clear_data():
    db.session.query(models.Admin).delete()
    db.session.query(models.Problem).delete()
    db.session.query(models.Client).delete()
    db.session.query(models.Submit).delete()


def init_db():
    clear_data()
    kubik = models.Admin(username='kubik369')
    kubik.set_password('password')
    db.session.add(kubik)

    ksp = models.Client(name="ksp", api_key='whatever')
    acm = models.Client(name='acm', api_key='acm')
    db.session.add(ksp)
    db.session.add(acm)

    fcia = models.Problem(id='fcia', client=ksp)
    jetoftak = models.Problem(id='jetoftak', client=acm)
    db.session.add(fcia)
    db.session.add(jetoftak)

    submit1 = models.Submit(client=ksp, problem=fcia, language=Language.Python)
    submit2 = models.Submit(
        client=acm, problem=jetoftak, status=TestingStatus.ACCEPTED, language=Language.Cpp
    )
    db.session.add(submit1)
    db.session.add(submit2)

    db.session.commit()
