from enum import Enum

DEFAULT_SUBMIT_PRIORITY = 0
MIN_SUBMIT_ID_SURROGATE = 0
MAX_SUBMIT_ID_SURROGATE = 99999

class TestingStatus(Enum):
    IN_QUEUE = 'IQ'
    ACCEPTED = 'AC'
    WRONG_ANSWER = 'WA'
    TIME_LIMIT_EXCEEDED = 'TLE'
    SECURITY_EXCEPTION = 'SE'
    INTERNAL_ERROR = 'IE'
    RUNTIME_EXCEPTION = 'RE'
    COMPILATION_ERROR = 'CE'


class Language(Enum):
    Python = 'py'
    Cpp = 'cpp'
    C = 'c'
    Java = 'java'
    Pascal = 'pas'
    D = 'd'
    Haskell = 'hs'
    NodeJS = 'js'
    Lisp = 'lisp'
    Perl = 'pl'
    Clojure = 'clj'
    CSharp = 'cs'
    Archive = 'zip'
    Text = 'txt'

    @classmethod
    def has_value(cls, value):
        return any(value == item.value for item in cls)
