"""empty message

Revision ID: 49c67b91d9be
Revises: 
Create Date: 2019-04-07 14:36:29.060593

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '49c67b91d9be'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('admin',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('username', sa.String(length=30), nullable=False),
    sa.Column('password_hash', sa.String(length=128), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('username')
    )
    op.create_table('client',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=20), nullable=False),
    sa.Column('api_key', sa.String(length=36), nullable=False),
    sa.Column('notification_url', sa.String(length=36), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('api_key'),
    sa.UniqueConstraint('name')
    )
    op.create_table('problem',
    sa.Column('id', sa.String(length=30), nullable=False),
    sa.Column('client_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['client_id'], ['client.id'], ),
    sa.PrimaryKeyConstraint('id', 'client_id')
    )
    op.create_table('submit',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('client_id', sa.Integer(), nullable=False),
    sa.Column('problem_id', sa.String(length=30), nullable=False),
    sa.Column('datetime', sa.DateTime(), nullable=False),
    sa.Column('language', sa.Enum('py', 'cpp', 'c', 'java', 'pas', 'd', 'hs', 'js', 'lisp', 'pl', 'clj', 'cs', 'zip', 'txt', name='language'), nullable=True),
    sa.Column('priority', sa.Integer(), nullable=True),
    sa.Column('status', sa.Enum('IQ', 'AC', 'WA', 'TLE', 'SE', 'IE', 'RE', 'CE', name='testingstatus'), nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.id'], ),
    sa.ForeignKeyConstraint(['problem_id'], ['problem.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('submit')
    op.drop_table('problem')
    op.drop_table('client')
    op.drop_table('admin')
    # ### end Alembic commands ###
