from unittest.mock import patch
import configparser
import unittest

from execute import (
    split_into_batches,
    testing_mode,
    is_file_sample,
)
from constants import TestingMode


class TestExecuteMethods(unittest.TestCase):

    def test_split_into_batches(self):
        input_files = [
            '00.sample.a.in', '00.sample.b.in',
            '01.a.in', '01.b.in', '01.c.in', '01.d.in', '01.e.in', '01.f.in',
                '01.g.in', '01.h.in', '01.i.in', '01.j.in', '01.k.in',
            '02.a.in', '02.b.in', '02.c.in', '02.d.in', '02.e.in', '02.f.in',
                '02.g.in', '02.h.in', '02.i.in', '02.j.in', '02.k.in',
                '02.l.in',
            '03.a.in', '03.b.in', '03.c.in', '03.d.in', '03.e.in', '03.f.in',
                '03.g.in', '03.h.in', '03.i.in', '03.j.in', '03.k.in',
                '03.l.in', '03.m.in',
            '04.a.in', '04.b.in', '04.c.in', '04.d.in', '04.e.in', '04.f.in',
                '04.g.in', '04.h.in', '04.i.in','04.j.in', '04.k.in',
        ]
        correct_batches = {
            '00': ['00.sample.a.in', '00.sample.b.in'],
            '01': [
                '01.a.in', '01.b.in', '01.c.in', '01.d.in', '01.e.in',
                '01.f.in', '01.g.in', '01.h.in', '01.i.in', '01.j.in',
                '01.k.in'
            ],
            '02': [
                '02.a.in', '02.b.in', '02.c.in', '02.d.in', '02.e.in',
                '02.f.in', '02.g.in', '02.h.in', '02.i.in', '02.j.in',
                '02.k.in', '02.l.in'
            ],
            '03': [
                '03.a.in', '03.b.in', '03.c.in', '03.d.in', '03.e.in',
                '03.f.in', '03.g.in', '03.h.in', '03.i.in', '03.j.in',
                '03.k.in', '03.l.in', '03.m.in'
            ],
            '04': [
                '04.a.in', '04.b.in', '04.c.in', '04.d.in', '04.e.in',
                '04.f.in', '04.g.in', '04.h.in', '04.i.in', '04.j.in',
                '04.k.in'
            ],
        }
        batches = split_into_batches(input_files)
        self.assertEqual(batches, correct_batches)

    def test_testing_mode(self):
        config = configparser.ConfigParser()
        config.add_section('task')
        config['task']['mode'] = str(TestingMode.TESTALL)

        mode = testing_mode(config)

        self.assertEqual(mode, TestingMode.TESTALL)

    def test_testing_mode_default_mode(self):
        config = configparser.ConfigParser()
        config.add_section('task')

        mode = testing_mode(config)

        self.assertEqual(mode, TestingMode.ACM)

    def test_is_file_sample(self):
        self.assertTrue(is_file_sample('00.sample.in'))
        self.assertTrue(is_file_sample('00.example.in'))
        self.assertFalse(is_file_sample('01.a.in'))


if __name__ == '__main__':
    unittest.main()
