import configparser
import logging
import os
import subprocess

from settings import (
    TASK_DIRECTORY,
    SUBMIT_LANGUAGE,
    SUBMIT_FILE_PATH,
)
from constants import (
    TASK_CONFIG_PATH,
)
from languages import supported_languages


def read_config(config_path):
    config = configparser.ConfigParser()
    config.read(config_path)
    return config


read_execution_metadata = read_config


def is_environment_ready():
    if not os.listdir(TASK_DIRECTORY):
        logging.error('INTERNAL ERROR: task directory is empty.')
        return False
    if not os.path.isfile(TASK_CONFIG_PATH):
        logging.error('INTERNAL ERROR: task config missing.')
        return False
    try:
        task_config_path = os.path.join(TASK_DIRECTORY, 'task.config')
        read_config(task_config_path)
    except configparser.ParsingError:
        logging.error('INTERNAL ERROR: failed to parse the task config file.')
        return False

    if not os.path.isfile(SUBMIT_FILE_PATH):
        logging.error('INTERNAL ERROR: submit file missing.')
        return False

    if SUBMIT_LANGUAGE not in supported_languages:
        logging.error('INTERNAL ERROR: unknown language.')
        return False

    return True


def execute_external(command_line, what_with_stderr=None):
    try:
        out = subprocess.check_output(command_line, stderr=subprocess.STDOUT)
        err = 0
    except subprocess.CalledProcessError as exc:
        out = exc.output
        err = exc.returncode
    return out, err


def pretty_diff_files(file_a, file_b):
    return execute_external([
        'progdiff', file_a, file_b, 'our ', 'your'
    ])
