from rq import Queue
from redis import Redis
import time

from worker.tasks import test_submit

# Tell RQ what Redis connection to use
redis_conn = Redis()
q = Queue(connection=redis_conn)

submit = {'uid': '12345', 'client': 'acm', 'task': 'fcia', 'language': 'zip'}
with open('./5MB.zip', 'rb') as submit_file:
    submit_file_bytes = submit_file.read()
submit['file'] = submit_file_bytes

job = q.enqueue(test_submit, submit)
print(job.result)   # => None

# Now, wait a while, until the worker is finished
time.sleep(2)
print(job.result)   # => 889