import time
import os
from configparser import ConfigParser

from .settings import TEMP_DIRECTORY


def store_submit_file(submit):
    submit_filename = f'{submit["uid"]}.{submit["language"]}'
    submit_filepath = os.path.join(TEMP_DIRECTORY, submit_filename)
    with open(submit_filepath, 'wb') as submit_file:
        submit_file.write(submit['file'])


def store_submit_config(submit):
    config = ConfigParser()
    config.add_section('submit')
    config.set('submit', 'client', submit['client'])
    config.set('submit', 'uid', str(submit['uid']))
    config.set('submit', 'task', str(submit['task']))
    config.set('submit', 'language', str(submit['language']))

    task_config_path = os.path.join(TEMP_DIRECTORY, 'task.config')
    with open(task_config_path, 'w') as task_config_file:
        config.write(task_config_file)


def store_submit(submit):
    store_submit_config(submit)
    store_submit_file(submit)


def test_submit(submit):
    #store_submit(submit)
    return 'Hello'
