#ifndef JMGRAPH_H
#define JMGRAPH_H

typedef struct {
    int n;
    int maxDegree;
    int **e;
} jmgraph;


// edges are v -> e[v][i], u -> e[u][j]
typedef struct {
    int v;
    int i;
    int u;
    int j;
} edgePair;


void initializeGraph(jmgraph *g, int n, int maxDegree);
void destroyGraph(jmgraph *g);
jmgraph *copyJmGraph(jmgraph *g);
jmgraph *newCubicGraph(int n);

void printGraph(jmgraph *g);

jmgraph *readGraph6(char *s);
jmgraph **readGraphsFromFileG6(const char *fileName, int *count);
jmgraph **readGraphsFromFileBA(const char *fileName, int *count);
char *writeGraph6(jmgraph *g);


/* ========================= operations ============================= */

void isolateVertex(jmgraph *g, int v);
void removeEdge(jmgraph *g, int v, int i);
void addEdge(jmgraph *g, int u, int v);
void suppressEdge(jmgraph *g, int u, int v);

/* ========================= invariants ============================= */

int deg(jmgraph *g, int v);
int distance(jmgraph *g, int v, int u);
int edgePairDistance(jmgraph *g, edgePair *p);
int shortestCycle(jmgraph *g, int v);
int girth(jmgraph *g);

int isColourable(jmgraph *g);
int isIrreducible(jmgraph *g);
int isStrongSnark(jmgraph *g);

int isRemovableEdgePair(jmgraph *g, edgePair *p);
int isRemovableVertexPair(jmgraph *g, int u, int v);



#endif
