#include <stdio.h>
#include <stdlib.h>

#include "jmgraph.h"


/*
int main() {
    const char *inputFilename = "/home/janko/praca/vyskum/data/snarks/martin/velke/6CON.198";
//    const char *inputFilename = "/home/janko/praca/vyskum/data/snarks/girth5/Generated_graphs.28.05.sn.cyc4.g6";
//    const char *inputFilename = "/home/janko/praca/vyskum/data/cubic/cub16.g6";
//    const char *inputFilename = "uncolourable.g6.in";

    int count;
    jmgraph **graphs = readGraphsFromFileBA(inputFilename, &count);
    for (int i = 0; i < count; i++) {
        jmgraph *g = graphs[i];
        if (!isColourable(g) && isIrreducible(g)) {
//            FILE *output = fopen("uncolourable.g6", "a");
            char *s = writeGraph6(g);
            printf("irreducible: %s\n", s);
//            fprintf(output, "%s\n", s);
            free(s);
//            fclose(output);
        }
        destroyGraph(g);
    }
    free(graphs);
}
*/

void reduce(jmgraph *g) {
    for (int u = 0; u < g->n; u++) {
        for (int i = 0; i < g->maxDegree; i++) {
            jmgraph *h = copyJmGraph(g);
            suppressEdge(h, u, g->e[u][i]);
            int gg = girth(h);
            if (gg >= 7)            
                printf("%3d %3d => %d %d\n", u, g->e[u][i], isColourable(h), gg);
            destroyGraph(h);
        }
    }
}


int main() {
    const char *inputFilename = "/home/janko/praca/vyskum/data/snarks/martin/girth7/G7.298";
//    const char *inputFilename = "/home/janko/praca/vyskum/data/snarks/girth4/Generated_graphs.10.04.sn.cyc4.g6";

    int count;
    jmgraph **graphs = readGraphsFromFileBA(inputFilename, &count);
//    jmgraph **graphs = readGraphsFromFileG6(inputFilename, &count);
    for (int i = 0; i < count; i++) {
        jmgraph *g = graphs[i];
        reduce(g);
        //printGraph(g);
        //printf("girth() = %d\n", girth(g));
        destroyGraph(g);
    }
    free(graphs);
}
