/*
 * Decompiled with CFR 0.152.
 */
package com.libfsm.automata.helpers;

import com.libfsm.automata.helpers.Pair;
import java.util.HashSet;
import java.util.Set;

public class Sets {
    public static <T> Set<T> union(Set<T> a, Set<T> b) {
        HashSet<T> union = new HashSet<T>(a);
        union.addAll(b);
        return union;
    }

    public static <T> Set<T> intersection(Set<T> a, Set<T> b) {
        HashSet<T> intersection = new HashSet<T>(a);
        intersection.retainAll(b);
        return intersection;
    }

    public static <T> Set<T> difference(Set<T> a, Set<T> b) {
        HashSet<T> intersection = new HashSet<T>(a);
        intersection.removeAll(b);
        return intersection;
    }

    public static <S, T> Set<Pair<S, T>> cartesianProduct(Set<S> a, Set<T> b) {
        HashSet product = new HashSet();
        a.forEach(s -> b.stream().map(t -> new Pair<Object, Object>(s, t)).forEach(product::add));
        return product;
    }

    public static <T> Set<Set<T>> powerSet(Set<T> originalSet) {
        HashSet<T> original = new HashSet<T>(originalSet);
        HashSet<Set<T>> powerSet = new HashSet<Set<T>>();
        int powerSetSize = 1 << original.size();
        for (int i = 0; i < powerSetSize; ++i) {
            HashSet subset = new HashSet();
            int mask = 1;
            for (Object t : original) {
                if ((mask & i) > 0) {
                    subset.add(t);
                }
                mask <<= 1;
            }
            powerSet.add(subset);
        }
        return powerSet;
    }
}

