/*
 * Decompiled with CFR 0.152.
 */
package com.libfsm.automata.machines;

import com.libfsm.automata.helpers.Pair;
import com.libfsm.automata.helpers.Sets;
import com.libfsm.automata.helpers.Triple;
import com.libfsm.automata.machines.DFA;
import com.libfsm.automata.machines.FSM;
import com.libfsm.automata.machines.FSMType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NFA
extends FSM {
    private Map<Pair<String, Character>, Set<String>> transitions = new HashMap<Pair<String, Character>, Set<String>>();

    public NFA(String name) {
        super(name);
        this.fsmType = FSMType.NFA;
    }

    @Override
    public void addState(String state) {
        this.states.add(state);
        this.alphabet.forEach(c -> this.transitions.put(new Pair<String, Character>(state, (Character)c), new HashSet()));
        this.transitions.put(new Pair<String, Character>(state, EPSILON), new HashSet());
    }

    @Override
    public void removeState(String state) {
        HashSet toRemove = new HashSet();
        this.transitions.forEach((key, value) -> value.forEach(q -> {
            if (((String)key.getFirst()).equals(state) || q.equals(state)) {
                toRemove.add(new Triple<String, Character, String>((String)key.getFirst(), (Character)key.getSecond(), (String)q));
            }
        }));
        toRemove.forEach(t -> this.removeTransition((String)t.getFirst(), (Character)t.getSecond(), (String)t.getThird()));
        this.states.remove(state);
    }

    @Override
    public void renameState(String oldName, String newName) {
        if (!this.states.contains(oldName) || this.states.contains(newName)) {
            return;
        }
        HashSet oldNameTransitions = new HashSet();
        HashSet toRemove = new HashSet();
        this.transitions.forEach((key, value) -> {
            if (((String)key.getFirst()).equals(oldName)) {
                toRemove.add(new Pair<String, Character>((String)key.getFirst(), (Character)key.getSecond()));
            }
            value.forEach(q -> {
                if (((String)key.getFirst()).equals(oldName) || q.equals(oldName)) {
                    oldNameTransitions.add(new Triple<String, Character, String>((String)key.getFirst(), (Character)key.getSecond(), (String)q));
                }
            });
        });
        boolean oldNameFinal = this.isFinalState(oldName);
        boolean oldNameInitial = this.initial.equals(oldName);
        if (oldNameInitial) {
            this.initial = newName;
        }
        this.removeState(oldName);
        this.addState(newName);
        if (oldNameFinal) {
            this.removeStateFinal(oldName);
            this.addStateFinal(newName);
        }
        oldNameTransitions.forEach(t -> {
            this.removeTransition((String)t.getFirst(), (Character)t.getSecond(), (String)t.getThird());
            if (((String)t.getFirst()).equals(oldName) && ((String)t.getThird()).equals(oldName)) {
                this.addTransition(newName, (Character)t.getSecond(), newName);
            } else if (((String)t.getFirst()).equals(oldName)) {
                this.addTransition(newName, (Character)t.getSecond(), (String)t.getThird());
            } else if (((String)t.getThird()).equals(oldName)) {
                this.addTransition((String)t.getFirst(), (Character)t.getSecond(), newName);
            }
        });
        toRemove.forEach(p -> this.transitions.remove(p));
    }

    @Override
    public void addTransition(String source, Character symbol, String destination) {
        if (source.equals(destination) && symbol.equals(EPSILON)) {
            return;
        }
        if (this.states.contains(source) && this.states.contains(destination) && (this.alphabet.contains(symbol) || symbol.equals(EPSILON))) {
            this.transitions.get(new Pair<String, Character>(source, symbol)).add(destination);
        }
    }

    @Override
    public void removeTransition(String source, Character symbol, String destination) {
        if (this.states.contains(source) && this.states.contains(destination) && (this.alphabet.contains(symbol) || symbol.equals(EPSILON))) {
            this.transitions.get(new Pair<String, Character>(source, symbol)).remove(destination);
        }
    }

    @Override
    public Set<Character> getAllTransitionsFromTo(String source, String destination) {
        HashSet<Character> result = new HashSet<Character>();
        this.transitions.forEach((k, v) -> v.forEach(q -> {
            if (((String)k.getFirst()).equals(source) && q.equals(destination)) {
                result.add((Character)k.getSecond());
            }
        }));
        return result;
    }

    @Override
    public Set<Pair<Character, String>> getAllTransitionsFrom(String source) {
        HashSet<Pair<Character, String>> result = new HashSet<Pair<Character, String>>();
        this.transitions.forEach((k, v) -> v.forEach(dest -> {
            if (((String)k.getFirst()).equals(source) && !((Character)k.getSecond()).equals(FSM.EPSILON)) {
                result.add(new Pair<Character, String>((Character)k.getSecond(), (String)dest));
            }
        }));
        return result;
    }

    @Override
    public Map<Pair<String, Character>, Set<String>> getTransitions() {
        return this.transitions;
    }

    @Override
    public Map<Pair<String, Character>, Set<String>> getEpsilonTransitions() {
        HashMap<Pair<String, Character>, Set<String>> result = new HashMap<Pair<String, Character>, Set<String>>();
        this.transitions.forEach((k, v) -> {
            if (((Character)k.getSecond()).equals(FSM.EPSILON)) {
                result.put((Pair<String, Character>)k, (Set<String>)v);
            }
        });
        return result;
    }

    @Override
    public void setAlphabet(Set<Character> alphabet) {
        Set oldAlphabet = this.alphabet;
        Set<Character> intersection = Sets.intersection(alphabet, oldAlphabet);
        Set<Character> diff = Sets.difference(alphabet, oldAlphabet);
        HashSet remaining = new HashSet();
        HashSet newTransitions = new HashSet();
        this.transitions.forEach((k, v) -> {
            if (v.isEmpty() && (intersection.contains(k.getSecond()) || ((Character)k.getSecond()).equals(EPSILON))) {
                newTransitions.add(new Pair<String, Character>((String)k.getFirst(), (Character)k.getSecond()));
            }
            v.forEach(q -> {
                if (intersection.contains(k.getSecond()) || ((Character)k.getSecond()).equals(EPSILON)) {
                    newTransitions.add(new Pair<String, Character>((String)k.getFirst(), (Character)k.getSecond()));
                    remaining.add(new Triple<String, Character, String>((String)k.getFirst(), (Character)k.getSecond(), (String)q));
                }
            });
        });
        this.states.forEach(q -> diff.forEach(c -> {
            newTransitions.add(new Pair<String, Character>((String)q, (Character)c));
            newTransitions.add(new Pair<String, Character>((String)q, EPSILON));
        }));
        this.transitions.clear();
        newTransitions.forEach(p -> this.transitions.put((Pair<String, Character>)p, new HashSet()));
        remaining.forEach(t -> this.addTransition((String)t.getFirst(), (Character)t.getSecond(), (String)t.getThird()));
        this.alphabet.addAll(alphabet);
    }

    @Override
    public Triple<Set<String>, Boolean, Integer> compute(String word, boolean verbose) {
        Set<String> currentStates = Set.of(this.initial);
        currentStates = this.epsilonClosure(currentStates);
        if (word.equals(EPSILON.toString())) {
            return new Triple<Set<String>, Boolean, Integer>(currentStates, currentStates.stream().anyMatch(this::isFinalState), word.length());
        }
        for (int i = 0; i < word.length(); ++i) {
            if (!(currentStates = this.computeStep(currentStates, Character.valueOf(word.charAt(i)))).isEmpty()) continue;
            return new Triple<Set<String>, Boolean, Integer>(currentStates, false, i + 1);
        }
        return new Triple<Set<String>, Boolean, Integer>(currentStates, currentStates.stream().anyMatch(this::isFinalState), word.length());
    }

    @Override
    public Set<String> computeStep(Set<String> states, Character c) {
        if (states.isEmpty() || !this.alphabet.contains(c)) {
            return new HashSet<String>();
        }
        Set<String> resultStates = states.stream().flatMap(q -> this.transitions.get(new Pair<String, Character>((String)q, c)).stream()).collect(Collectors.toSet());
        resultStates.addAll(this.epsilonClosure(resultStates));
        return resultStates;
    }

    @Override
    public Set<String> epsilonClosure(Set<String> states) {
        HashSet<String> closureStates = new HashSet<String>(states);
        states.forEach(q -> this.epsilonClosureHelper((String)q, (Set<String>)closureStates));
        return closureStates;
    }

    private void epsilonClosureHelper(String state, Set<String> closureStates) {
        this.transitions.get(new Pair<String, Character>(state, EPSILON)).forEach(q -> {
            if (!closureStates.contains(q)) {
                closureStates.add((String)q);
                this.epsilonClosureHelper((String)q, closureStates);
            }
        });
    }

    public static NFA fromDFA(DFA dfa) {
        NFA result = new NFA("NFAfromDFA");
        result.setAlphabet(dfa.getAlphabet());
        dfa.getStates().forEach(result::addState);
        dfa.getStates().forEach(p -> dfa.getStates().forEach(q -> dfa.getAllTransitionsFromTo((String)p, (String)q).forEach(c -> result.addTransition((String)p, (Character)c, (String)q))));
        result.setInitial(dfa.getInitial());
        dfa.getFinalStates().forEach(result::addStateFinal);
        return result;
    }

    @Override
    public boolean isCorrectlyDefined() {
        return !this.initial.isEmpty() && !this.alphabet.isEmpty() && !this.states.isEmpty();
    }

    @Override
    public String notCorrectlyDefinedText() {
        return "NFA is not defined correctly! Please check alphabet/initial state.";
    }

    @Override
    public void writeToFile(File file) {
        try (PrintWriter printWriter = new PrintWriter(file);){
            printWriter.print(this);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public FSM copy() {
        NFA result = new NFA(this.name);
        this.states.forEach(result::addState);
        this.finalStates.forEach(result::addStateFinal);
        result.setAlphabet(this.alphabet);
        result.setInitial(this.initial);
        this.transitions.forEach((k, v) -> v.forEach(q -> result.addTransition((String)k.getFirst(), (Character)k.getSecond(), (String)q)));
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("\n");
        sb.append("\t");
        sb.append("\"type\" : \"NFA\",").append("\n");
        String alphFormat = String.join((CharSequence)"', '", this.alphabet.stream().map(Object::toString).collect(Collectors.toSet()));
        sb.append("\t");
        sb.append("\"alphabet\" : ['");
        sb.append(alphFormat).append("'],").append("\n");
        String statesFormat = String.join((CharSequence)"\", \"", this.states);
        sb.append("\t");
        sb.append("\"states\" : [\"");
        sb.append(statesFormat).append("\"],").append("\n");
        HashSet transitionsFormat = new HashSet();
        this.transitions.forEach((key, value) -> value.forEach(q -> transitionsFormat.add("\t\t{\n\t\t\t\"source\" : \"" + (String)key.getFirst() + "\",\n\t\t\t\"symbol\" : '" + key.getSecond() + "',\n\t\t\t\"destination\" : \"" + q + "\"\n\t\t}")));
        String transitionsFormatAll = String.join((CharSequence)",\n", transitionsFormat);
        sb.append("\t");
        sb.append("\"transitions\" : [").append("\n");
        sb.append(transitionsFormatAll).append("\n\t],");
        sb.append("\n\t\"initial\" : \"");
        sb.append(this.initial);
        sb.append("\",\n");
        sb.append("\t\"final_states\" : [\"");
        String finalFormat = String.join((CharSequence)"\", \"", this.finalStates);
        sb.append(finalFormat).append("\"]\n");
        sb.append("}");
        return sb.toString();
    }
}

