/*
 * Decompiled with CFR 0.152.
 */
package com.libfsm.operations.unary;

import com.libfsm.automata.helpers.Sets;
import com.libfsm.automata.machines.DFA;
import com.libfsm.automata.machines.FSM;
import com.libfsm.operations.unary.UnaryOperation;
import java.util.Map;
import java.util.Set;

class Complement
implements UnaryOperation {
    private Map<Integer, String> steps = Map.ofEntries(Map.entry(0, "0. No special init step\n"), Map.entry(1, "1. In this step we copy alphabet from input dfa"), Map.entry(2, "2. In this step we copy states from input dfa"), Map.entry(3, "3. In this step we copy transitions from input dfa"), Map.entry(4, "4. In this step we set initial state of input dfa as initial state of result dfa"), Map.entry(5, "5. In this step we set rejecting states of input dfa as final states of result dfa"), Map.entry(6, "Completed"));

    Complement() {
    }

    @Override
    public FSM apply(FSM fsm) {
        DFA result = new DFA("Complement ".concat(fsm.getName()));
        result.setAlphabet(fsm.getAlphabet());
        Set<String> dfaStates = fsm.getStates();
        dfaStates.forEach(result::addState);
        fsm.getStates().forEach(p -> fsm.getStates().forEach(q -> fsm.getAllTransitionsFromTo((String)p, (String)q).forEach(c -> result.addTransition((String)p, (Character)c, (String)q))));
        result.setInitial(fsm.getInitial());
        Set<String> dfaFinalStates = fsm.getFinalStates();
        Set<String> resultFinalStates = Sets.difference(dfaStates, dfaFinalStates);
        resultFinalStates.forEach(result::addStateFinal);
        return result;
    }

    @Override
    public Map<Integer, String> getSteps() {
        return this.steps;
    }
}

