//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Settings.h"
#include "Viewer.h"
#include "Structures.h"
#include <math.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmSettings *frmSettings;
//---------------------------------------------------------------------------
__fastcall TfrmSettings::TfrmSettings(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TfrmSettings::Button1Click(TObject *Sender)
{
//set process
  if(this->rdbSphere->Checked){
      FrmMonitor->p.Function = Sphere;
  }
  if(this->rdbGenus3->Checked){
      FrmMonitor->p.Function = Genus3;
  }
  if(this->rdbJack->Checked){
      FrmMonitor->p.Function = Jack;
  }
  if(this->rdbTorus->Checked){
      FrmMonitor->p.Function = Torus;
  }

  FrmMonitor->p.Config.SUBDIVIDE = ( (FrmMonitor->p.Config.MAX_DEPTH > 0) ? 1 : 0) ;
  FrmMonitor->p.Config.RC_RATIO = pow(2, FrmMonitor->p.Config.MAX_DEPTH);
  FrmMonitor->p.Config.STEP = FrmMonitor->p.Config.BIG_STEP / (double) FrmMonitor->p.Config.RC_RATIO;

  FrmMonitor->p.Config.MAX_STEP3_QUAD = FrmMonitor->p.Config.MAX_STEP3 * FrmMonitor->p.Config.MAX_STEP3;
  FrmMonitor->p.Config.MIN_STEP3_QUAD = FrmMonitor->p.Config.MIN_STEP3 * FrmMonitor->p.Config.MIN_STEP3;

  FrmMonitor->p.Config.ALPHA_DIVIDE = FrmMonitor->p.Config.ALPHA_STEP;

  FrmMonitor->p.quit = 0;

  FrmMonitor->Show();
  this->Hide();
}
//---------------------------------------------------------------------------



void __fastcall TfrmSettings::edtRCSExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.BIG_STEP = StrToFloat(this->edtRCS->Text);
  }
  catch(...){
    this->edtRCS->Text = FloatToStr(FrmMonitor->p.Config.BIG_STEP);
  }
}
//---------------------------------------------------------------------------



void __fastcall TfrmSettings::edtSBDLExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.MAX_DEPTH = StrToInt(this->edtSBDL->Text);
  }
  catch(...){
    this->edtSBDL->Text = IntToStr(FrmMonitor->p.Config.MAX_DEPTH);
  }
}
//---------------------------------------------------------------------------


void __fastcall TfrmSettings::edtSBDANGExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.ALPHA_SUBDIVISON = cos(StrToFloat(this->edtSBDANG->Text));
  }
  catch(...){
    this->edtSBDANG->Text = FloatToStr(acos(FrmMonitor->p.Config.ALPHA_SUBDIVISON));
  }
}
//---------------------------------------------------------------------------


void __fastcall TfrmSettings::edtMinValExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.MIN_VALUE = StrToFloat(this->edtMinVal->Text);
  }
  catch(...){
    this->edtMinVal->Text = FloatToStr(FrmMonitor->p.Config.MIN_VALUE);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::edtXExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.STARTING_POSITION.X = StrToFloat(this->edtX->Text);
  }
  catch(...){
    this->edtX->Text = FloatToStr(FrmMonitor->p.Config.STARTING_POSITION.X);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::edtYExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.STARTING_POSITION.Y = StrToFloat(this->edtY->Text);
  }
  catch(...){
    this->edtY->Text = FloatToStr(FrmMonitor->p.Config.STARTING_POSITION.Y);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::edtZExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.STARTING_POSITION.Z = StrToFloat(this->edtZ->Text);
  }
  catch(...){
    this->edtZ->Text = FloatToStr(FrmMonitor->p.Config.STARTING_POSITION.Z);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::edtMaxHExit(TObject *Sender)
{
try{
    FrmMonitor->p.Config.MAX_STEP3 = StrToFloat(this->edtMaxH->Text);
  }
  catch(...){
    this->edtMaxH->Text = FloatToStr(FrmMonitor->p.Config.MAX_STEP3);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::edtMinHExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.MIN_STEP3 = StrToFloat(this->edtMinH->Text);
  }
  catch(...){
    this->edtMinH->Text = FloatToStr(FrmMonitor->p.Config.MIN_STEP3);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::edtALimExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.ALPHA_STEP = cos(StrToFloat(this->edtALim->Text));
  }
  catch(...){
    this->edtALim->Text = FloatToStr(acos(FrmMonitor->p.Config.ALPHA_STEP));
  }
}
//---------------------------------------------------------------------------


void __fastcall TfrmSettings::edtKnExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.MAX_TN = StrToFloat(this->edtKn->Text);
  }
  catch(...){
    this->edtKn->Text = FloatToStr(FrmMonitor->p.Config.MAX_TN);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::edtNoTRExit(TObject *Sender)
{
  try{
    FrmMonitor->p.Config.MAX_TR_COUNT = StrToInt(this->edtNoTR->Text);
  }
  catch(...){
    this->edtNoTR->Text = IntToStr(FrmMonitor->p.Config.MAX_TR_COUNT);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::Button3Click(TObject *Sender)
{
  if(this->rdbSphere->Checked){
    FrmMonitor->p.Config.BIG_STEP = 0.512;
    FrmMonitor->p.Config.MAX_DEPTH = 4;
    FrmMonitor->p.Config.ALPHA_SUBDIVISON = 0.7;
    FrmMonitor->p.Config.MIN_VALUE = 0.000001;

    FrmMonitor->p.Config.STARTING_POSITION.X = 3.0;
    FrmMonitor->p.Config.STARTING_POSITION.Y = 0.0;
    FrmMonitor->p.Config.STARTING_POSITION.Z = 0.0;

    FrmMonitor->p.Config.MAX_STEP3 = 0.25;
    FrmMonitor->p.Config.MIN_STEP3 = 0.0;
    FrmMonitor->p.Config.MAX_TN = 1.7;
    FrmMonitor->p.Config.ALPHA_STEP = 0.95;

    FrmMonitor->p.Config.MAX_TR_COUNT = 0;
  }
  else if(this->rdbGenus3->Checked){
    FrmMonitor->p.Config.BIG_STEP = 0.512;
    FrmMonitor->p.Config.MAX_DEPTH = 4;
    FrmMonitor->p.Config.ALPHA_SUBDIVISON = 0.7;
    FrmMonitor->p.Config.MIN_VALUE = 0.000001;

    FrmMonitor->p.Config.STARTING_POSITION.X = 2.7;
    FrmMonitor->p.Config.STARTING_POSITION.Y = 0.0;
    FrmMonitor->p.Config.STARTING_POSITION.Z = 0.0;

    FrmMonitor->p.Config.MAX_STEP3 = 0.178;
    FrmMonitor->p.Config.MIN_STEP3 = 0.045;
    FrmMonitor->p.Config.MAX_TN = 1.7;
    FrmMonitor->p.Config.ALPHA_STEP = 0.95;

    FrmMonitor->p.Config.MAX_TR_COUNT = 0;
  }
  else if(this->rdbTorus->Checked){
    FrmMonitor->p.Config.BIG_STEP = 0.512;
    FrmMonitor->p.Config.MAX_DEPTH = 4;
    FrmMonitor->p.Config.ALPHA_SUBDIVISON = 0.7;
    FrmMonitor->p.Config.MIN_VALUE = 0.000001;

    FrmMonitor->p.Config.STARTING_POSITION.X = 3.0;
    FrmMonitor->p.Config.STARTING_POSITION.Y = 0.0;
    FrmMonitor->p.Config.STARTING_POSITION.Z = 0.0;

    FrmMonitor->p.Config.MAX_STEP3 = 0.06;
    FrmMonitor->p.Config.MIN_STEP3 = 0.06;
    FrmMonitor->p.Config.MAX_TN = 1.7;
    FrmMonitor->p.Config.ALPHA_STEP = -1.0;

    FrmMonitor->p.Config.MAX_TR_COUNT = 0;
  }
  else if(this->rdbJack->Checked){
    FrmMonitor->p.Config.BIG_STEP = 0.512;
    FrmMonitor->p.Config.MAX_DEPTH = 4;
    FrmMonitor->p.Config.ALPHA_SUBDIVISON = 0.7;
    FrmMonitor->p.Config.MIN_VALUE = 0.000001;

    FrmMonitor->p.Config.STARTING_POSITION.X = -1.9;
    FrmMonitor->p.Config.STARTING_POSITION.Y = 0.0;
    FrmMonitor->p.Config.STARTING_POSITION.Z = 0.0;

    FrmMonitor->p.Config.MAX_STEP3 = 0.1;
    FrmMonitor->p.Config.MIN_STEP3 = 0.05;
    FrmMonitor->p.Config.MAX_TN = 1.7;
    FrmMonitor->p.Config.ALPHA_STEP = 0.95;

    FrmMonitor->p.Config.MAX_TR_COUNT = 0;
  }

  this->edtRCS->Text = FloatToStr(FrmMonitor->p.Config.BIG_STEP);

  this->edtSBDL->Text = IntToStr(FrmMonitor->p.Config.MAX_DEPTH);
  this->edtSBDANG->Text = FloatToStr(acos(FrmMonitor->p.Config.ALPHA_SUBDIVISON));
  this->edtMinVal->Text = FloatToStr(FrmMonitor->p.Config.MIN_VALUE);

  this->edtX->Text = FloatToStr(FrmMonitor->p.Config.STARTING_POSITION.X);
  this->edtY->Text = FloatToStr(FrmMonitor->p.Config.STARTING_POSITION.Y);
  this->edtZ->Text = FloatToStr(FrmMonitor->p.Config.STARTING_POSITION.Z);

  this->edtMaxH->Text = FloatToStr(FrmMonitor->p.Config.MAX_STEP3);
  this->edtMinH->Text = FloatToStr(FrmMonitor->p.Config.MIN_STEP3);
  this->edtALim->Text = FloatToStr(acos(FrmMonitor->p.Config.ALPHA_STEP));
  this->edtKn->Text = FloatToStr(FrmMonitor->p.Config.MAX_TN);
  this->edtNoTR->Text = IntToStr(FrmMonitor->p.Config.MAX_TR_COUNT);

}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::Button4Click(TObject *Sender)
{
  this->Close();  
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::FormCreate(TObject *Sender)
{
  this->first_pass = 1;
}
//---------------------------------------------------------------------------

void __fastcall TfrmSettings::FormShow(TObject *Sender)
{
  if(this->first_pass){
    this->Button3Click(NULL);
    this->first_pass = 0;
  }
}
//---------------------------------------------------------------------------

