//---------------------------------------------------------------------------


#pragma hdrstop

#include "WRL.h"
#include <math.h>
#include <stdio.h>


//---------------------------------------------------------------------------

void ExportTriangles(TProcess *p, char * name){

  FILE *out;


  if ((out = fopen(name, "wt")) == NULL)
  {
    fprintf(stderr, "Cannot open output file.\n");
    return;
  }

//write header
  fprintf(out, "\
#VRML V2.0 utf8                               \n\
#cube size = %f \n\
#max subdivision level = %i \n\
#cube subdivision angle = %f \n\
#limit angle for triangles = %f \n\
#min triangle size = %f \n\
#max triangle size = %f \n\
#Klim = %f \n\
#MC time = %f \n\
#MT time = %f \n\
#Total time = %f \n\
", p->Config.BIG_STEP,
      p->Config.MAX_DEPTH,
      p->Config.ALPHA_SUBDIVISON,
      p->Config.ALPHA_STEP,
      p->Config.MIN_STEP3,
      p->Config.MAX_STEP3,
      p->Config.MAX_TN,
      ((double)(p->Stats.Cubes.End - p->Stats.Cubes.Start)) / CLK_TCK,
      ((double)(p->Stats.Triangles.End - p->Stats.Triangles.Start)) / CLK_TCK,
      ((double)(p->Stats.All.End - p->Stats.All.Start)) / CLK_TCK
      );

  fprintf(out, "\
DEF Start Viewpoint {                         \n\
  position 0 0 30                             \n\
  orientation 0 0 -15 0                       \n\
  fieldOfView 0                               \n\
  description \"Start\"                       \n\
  }                                           \n\
DEF my_model Transform {                      \n\
  translation 0 0 0                           \n\
  children [                                  \n\
    Shape {                                   \n\
      appearance Appearance {                         \n\
        material Material {                           \n\
          diffuseColor 0.196078 0.784314 0.313725     \n\
          specularColor 1 1 1                         \n\
          shininess 0.45                              \n\
          }                                           \n\
        }                                             \n\
      geometry DEF my_model-FACES IndexedFaceSet {    \n\
        ccw TRUE                                      \n\
        solid TRUE                                   \n\
        normalPerVertex TRUE                          \n");

//START of vertices coordinates
  fprintf(out,"\
        coord DEF my_model-COORD Coordinate {         \n\
          point [\n");

  for(T3DPoints *AP = p->Vertices; AP != NULL; AP = AP->Next){
    fprintf(out, "\
            %f %f %f \n",
            AP->Point.X,
            AP->Point.Y,
            AP->Point.Z);
  }

  fprintf(out,"\
          ]           \n\
        } \n");
//END of vertices coordinates

//START of normals
  fprintf(out,"\
        normal Normal {         \n\
          vector [\n");
/**/
  for(T3DNormals *AN = p->Normals; AN != NULL; AN = AN->Next){
    fprintf(out, "\
            %f %f %f \n",
            (-1.0) * AN->Normal.X,
            (-1.0) * AN->Normal.Y,
            (-1.0) * AN->Normal.Z);
  }
/** /
  for(T3DPoints *AP = p->Vertices; AP != NULL; AP = AP->Next){
    fprintf(out, "\
            %f %f %f \n",
            -AP->Point.X / sqrt(AP->Point.X * AP->Point.X + AP->Point.Y * AP->Point.Y + AP->Point.Z * AP->Point.Z),
            -AP->Point.Y / sqrt(AP->Point.X * AP->Point.X + AP->Point.Y * AP->Point.Y + AP->Point.Z * AP->Point.Z),
            -AP->Point.Z / sqrt(AP->Point.X * AP->Point.X + AP->Point.Y * AP->Point.Y + AP->Point.Z * AP->Point.Z));
  } /**/

  fprintf(out,"\
          ]           \n\
        } \n");
//END of normals



//START of triangles vertices
  fprintf(out,"\
        coordIndex [          \n");
  for(TTriangles *AT = p->FoundTriangles; AT != NULL; AT = AT->Next){
    fprintf(out,"\
          %i, %i, %i, -1, \n",
          p->Vertices->Index - AT->Triangle.Vertices[0]->Index,
          p->Vertices->Index - AT->Triangle.Vertices[1]->Index,
          p->Vertices->Index - AT->Triangle.Vertices[2]->Index);
  }

  fprintf(out,"\
          ]           \n");
//END of triangles vertices

//START of triangles normals
  fprintf(out,"\
        normalIndex [          \n");
  for(TTriangles *AT = p->FoundTriangles; AT != NULL; AT = AT->Next){
    fprintf(out,"\
          %i, %i, %i, -1, \n",
          p->Vertices->Index - AT->Triangle.Normals[0]->Index,
          p->Vertices->Index - AT->Triangle.Normals[1]->Index,
          p->Vertices->Index - AT->Triangle.Normals[2]->Index);
  }

  fprintf(out,"\
          ]           \n");
//END of triangles normals

//write footer
  fprintf(out, "\
        }           \n\
      }             \n\
    ]               \n\
  }                 \n");


  fclose(out);
}


#pragma package(smart_init)
