# All models needed for training.

import numpy as np
from sklearn import linear_model, svm, ensemble, neighbors

def get_all_models():
    '''List of all models and ranges for parameters for GridSearch.'''
    return [
        (linear_model.LinearRegression(), True,
            {}),
        (linear_model.Ridge(), True,
            {'alpha':np.logspace(-3, 3, 49)}),
        (linear_model.Lasso(max_iter=50000), True,
            {'alpha':np.logspace(-3, 3, 49)}),
        (linear_model.LassoLars(max_iter=50000, normalize=False), True,
            {'alpha':np.logspace(-3, 3, 49)}),
        (linear_model.ElasticNet(max_iter=10000), True,
            {'alpha':np.logspace(-3, 3, 49)}),
        (svm.LinearSVR(), True,
            {'C': np.logspace(-2, 3, 36)}),
        (ensemble.RandomForestRegressor(min_samples_leaf=4), False,
            {'n_estimators': [1,5,10,15]}),
    ]

def get_all_rfe_models():
    '''List of all models and ranges for parameters for GridSearch on RFE(CV).'''
    return [
        (linear_model.LinearRegression(), True,
            {}),
        (linear_model.Ridge(), True,
            {'estimator__alpha':np.logspace(-3, 3, 49)}),
        (linear_model.Lasso(max_iter=100000), True,
            {'estimator__alpha':np.logspace(-3, 3, 49)}),
        (linear_model.LassoLars(max_iter=100000, normalize=False), True,
            {'estimator__alpha':np.logspace(-3, 3, 49)}),
        (linear_model.ElasticNet(max_iter=20000), True,
            {'estimator__alpha':np.logspace(-3, 3, 49)}),
        (svm.LinearSVR(), True,
            {'estimator__C': np.logspace(-2, 3, 36)}),
        (ensemble.RandomForestRegressor(min_samples_leaf=4), False,
            {'estimator__n_estimators': [1,5,10,15]}),
    ]
