USER_TIME_FILE = 'user_time_data.csv'
SITE_URL = 'https://logic-games.spb.ru/sokoban/'

FEATURES_FILE = 'features.csv'
TRAIN_FEATURES_FILE = 'features_train.csv'
TEST_FEATURES_FILE = 'features_test.csv'
TEST_IDS_FILE = 'test_ids.txt'

FEATURE_CNT = 14
FIELDNAMES = [
    'id', 'box_count', 'tile_count', 'width', 'height', 
    'reachable_tile_count', 'shortest_path', 'reachable_states_count',
    'viable_states_count', 'shortest_boxes_path', 'scc_count', 'scc_shortest',
    'counter_intuitive_steps', 'astar_states_count', 'good_boxes_tiles',
    'avg_log_time', '25per', 'avg_time', 'stdev'
]

CPP_DIR = '../sokoban_common_cpp'
CPP_COMPILE = 'g++ -Wall -std=c++11 -o %s %s -lboost_graph -lboost_serialization -O2'
CPP_RUN_PREFIX = '/usr/bin/time -f "%C\n mem=%K RSS=%M elapsed=%E cpu.sys=%S .user=%U"'

CREATE = 'create_graph'
SIMPLE_BFS = 'simple_bfs'
STATE_BFS = 'state_bfs'
REVERSE_STATE_BFS = 'reverse_state_bfs'
AREA_BFS = 'area_bfs'
CREATE_SCC = 'create_scc'
SCC_BFS = 'scc_bfs'
COUNTER_INTUITIVE = 'counter_intuitive'
ASTAR = 'astar'
GOOD_TILES = 'good_tiles'

def get_predict_col(type):
    if type == 'avg_log':
        return FEATURE_CNT + 1
    if type == '25per':
        return FEATURE_CNT + 2
    if type == 'avg':
        return FEATURE_CNT + 3
    return None

def get_predict_col_name(type):
    col = get_predict_col(type)
    if col is None: return None
    return FIELDNAMES[col]

def get_level_name(id):
    return 'sokoban_id=%s.level' % str(id)
