# Script for scraping plays of users with at least 3 played games.
# geckodriver needs to be downloaded, and be in PATH

from selenium import webdriver
from time import sleep
import json, datetime
import os, csv
import numpy as np
import matplotlib.pyplot as plt

import constants

current_dir = os.getcwd()
data_dir = 'data'.join(current_dir.rsplit('code', 1))

def get_players_games(id):
    x = driver.execute_async_script('''
        var done = arguments[0];
        this.controller.cs.sendRequest(
            "/gw/shared/loadPlayerDetail.php",
            { playerId: %d },
            function(i, r) {
                done(r);
            }
        );
    ''' % (id, ))
    if not x['canPlayGames']:
        return []
    won = list(filter(lambda g: g['playerWinTime'] > 0, x['playerDetail']))
    return list(map(lambda g: {g['gameId']: g['playerWinTime']/1000.0}, won))

driver = webdriver.Firefox()
driver.get(constants.SITE_URL)

player_ids = driver.execute_async_script('''
    var done = arguments[0];
    this.controller.cs.sendRequest(
        "/gw/shared/loadRatingsBySolvedCount.php",
        {sortBy: 0, order: 1, filter: 0, count: 30500, subFilter: 0, timeFilter: 0, segmentFilter: 0, gameVariationId: 7},
        function(e, r) {
            done(r);
        }
    );
''')

ids = list(map(lambda u: u['playerId'], player_ids['ratings']))

for i, id in enumerate(ids):
    print('[%5d] %8d: %s' % (i, id, datetime.datetime.now()))
    data_row = get_players_games(id)
    if len(data_row) < 3:
        continue
    data_row += [{'user_id': id}]
    with open('user_data.log', 'a+') as out:
        out.write('%s\n' % json.dumps(data_row))

level_ids = ['user_id', 99, 113, 116, 118, 135, 146, 147, 149, 154, 160, 163, 166, 168, 170, 174, 179, 190, 192, 202, 203, 206, 214, 242, 243, 244, 245, 246, 248, 249, 251, 252, 254, 256, 260, 261, 269, 318, 325, 331, 349, 350, 351, 352, 360, 372, 376, 378, 380, 399, 404, 405, 406, 407, 414, 435, 442, 466, 552, 575, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 708, 710, 711, 714, 715, 716, 717, 718, 720, 722, 723, 724, 727, 729, 730, 732, 733, 734, 735, 738, 739, 741, 742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 754, 756, 761, 762, 763, 764, 765, 766, 768, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 830, 831, 832, 833, 834, 839, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 862, 867, 869, 870, 872, 874, 875, 876, 885, 886, 891, 892, 896, 897, 898, 901, 902, 903, 904, 905, 906, 907, 908, 909, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 925, 926, 930, 931, 932, 934, 936, 938, 939, 941, 942, 943, 944, 945, 949, 952, 953, 954, 955, 956, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 980, 981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1010, 1011, 1012, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1036, 1044, 1045, 1046, 1048, 1049, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1106, 1107, 1108, 1109, 1114, 1115, 1116, 1117, 1119, 1120, 1121, 1124, 1125, 1134, 1135, 1142, 1147, 1148, 1184, 1230, 1444, 1534, 1542, 1548, 1561, 1608, 1695, 1706, 1707, 1710, 1754, 1771, 1789, 1791, 1792, 1798, 1799, 1811, 1859, 1881, 1897, 1914, 1915, 1929, 1934, 1938, 1940, 1949, 1964, 1970, 1972, 1975, 1981, 1982, 1990, 1998, 2002, 2004, 2006, 2007, 2008, 2009, 2011, 2012, 2015, 2016, 2018, 2027, 2032, 2034, 2039, 2046, 2048, 2064, 2067, 2073, 2074, 2082, 2087, 2089, 2116, 2119, 2131, 2133, 2134, 2145, 2151, 2164, 2167, 2175, 2177, 2179, 2185, 2191, 2195, 2196, 2204, 2208, 2214, 2215, 2229, 2234, 2237, 2244, 2246, 2254, 2260, 2264, 2269, 2275, 2280, 2282, 2290, 2299, 2303, 2309, 2310, 2311, 2313, 2320, 2326, 2328, 2331, 2345, 2346, 2347, 2348, 2352, 2361, 2365, 2369, 2376, 2377, 2388, 2395, 2397, 2398, 2408, 2413, 2420, 2423, 2425, 2426, 2430, 2435, 2448, 2450, 2456, 2459, 2460, 2464, 2467, 2471, 2478, 2481, 2486, 2487, 2488, 2492, 2499, 2502, 2506, 2508, 2509, 2510, 2512, 2513, 2515, 2516, 2517, 2518, 2520, 2524, 2526, 2527, 2531, 2532, 2533, 2534, 2535, 2536, 2539, 2541, 2543, 2547, 2548, 2551, 2554, 2555, 2558, 2561, 2563, 2565, 2568, 2578, 2581, 2583, 2585, 2586, 2587, 2592, 2596, 2599, 2600, 2602, 2614, 2619, 2621, 2634, 2639, 2644, 2646, 2647, 2648, 2652, 2654, 2655, 2665, 2667, 2668, 2671, 2674, 2684, 2693, 2694, 2696, 2697, 2698, 2719, 2729, 2733, 2735, 2741, 2748, 2759, 2771, 2779, 2782, 2785, 2786, 2787, 2789, 2790, 2792, 2795, 2800, 2804, 2807, 2808, 2809, 2813, 2814, 2815, 2821, 2827, 2828, 2832, 2833, 2835, 2838, 2841, 2851, 2866, 2869, 2878, 2884, 2885, 2886, 2887, 2897, 2905, 2920, 2930, 2931, 2934, 2939, 2940, 2942, 2951, 2955, 2965, 2966, 2982, 2983, 2992, 3001, 3002, 3027, 3036, 3042, 3046, 3055, 3058, 3064, 3071, 3086, 3090, 3094, 3105, 3106, 3107, 3109, 3112, 3113, 3119, 3122, 3123, 3124, 3125, 3127, 3130, 3131, 3132, 3137, 3138, 3139, 3142, 3147, 3172, 3174, 3182, 3184, 3185, 3189, 3190, 3198, 3200, 3202, 3207, 3208, 3212, 3235, 3236, 3240, 3241, 3242, 3243, 3246, 3247, 3250, 3253, 3262, 3303, 3304, 3305, 3306, 3307, 3308, 3326, 3330, 3412, 3446, 3491, 3504, 3505]
level_ids = [str(x) for x in level_ids]
set_level_ids = set(level_ids)

all_data = []
with open('user_data.log', 'r') as inp:
    for line in inp:
        z = json.loads(line.strip())
        pom = list(filter(lambda x: x in set_level_ids, [list(k.keys())[0] for k in z]))
        if len(pom) > 1: all_data.append(z)

# Magicly write output to csv.
with open(os.path.join(data_dir, constants.USER_TIME_FILE), 'w', newline='') as csvfile:
    writer = csv.DictWriter(csvfile, fieldnames=level_ids, dialect='unix', quoting=csv.QUOTE_NONE, extrasaction='ignore')

    writer.writeheader()
    for data_row in all_data:
        writer.writerow({ k: v for d in data_row for k, v in d.items() })
