#include "helpers.cpp"

#include<cstdio>
#include<vector>

#include <boost/config.hpp>
#include <boost/graph/adjacency_list.hpp>
#include <boost/property_map/property_map.hpp>
#include <boost/graph/dijkstra_shortest_paths.hpp>
#include <boost/property_map/property_map.hpp>

using namespace std;
using namespace boost;

typedef adjacency_list<listS, vecS, directedS, Vertex, Edge> Graph;
typedef graph_traits<Graph>::vertex_descriptor vertex_t;
typedef graph_traits<Graph>::vertices_size_type Size;

Graph G;
unsigned N;
vector<vertex_t> p;
vector<Size> d;

void do_dijkstra(vertex_t starting) {
    d.resize(N, 0);
    p.resize(N);

    dijkstra_shortest_paths(G, starting,
        predecessor_map(make_iterator_property_map(p.begin(), get(vertex_index, G))).
        distance_map(make_iterator_property_map(d.begin(), get(vertex_index, G))).
        weight_map(get(&Edge::pushed, G)));
}

int main(int argc , char* argv[]) {
    if (argc < 2) {
        return 0;
    }
    string filename = argv[1];
    N = read(G, filename);

    vertex_t starting = get_starting(G);

    do_dijkstra(starting);

    printf("%lu\n", get_shortest_path(G, d));

    return 0;
}
