#include "helpers.cpp"

#include<cstdio>
#include<vector>

#include <boost/config.hpp>
#include <boost/graph/adjacency_list.hpp>
#include <boost/graph/graph_utility.hpp>
#include <boost/graph/visitors.hpp>
#include <boost/graph/breadth_first_search.hpp>
#include <boost/property_map/property_map.hpp>

using namespace std;
using namespace boost;

typedef adjacency_list<setS, vecS, directedS, SccVertex> SccGraph;
typedef graph_traits<SccGraph>::vertex_descriptor vertex_scc_t;
typedef graph_traits<SccGraph>::vertex_iterator vertex_iter;
typedef graph_traits<SccGraph>::vertices_size_type Size;

SccGraph scc_graph;
unsigned N;
vector<Size> d;

void do_bfs(vertex_scc_t starting) {
    d.resize(N, 0);
    breadth_first_search(
            scc_graph, starting, 
            visitor(
                make_bfs_visitor(record_distances(&d[0], on_tree_edge()))
                ));
}

int main(int argc , char* argv[]) {
    if (argc < 2) {
        return 0;
    }
    {
        string filename = argv[1];
        N = read(scc_graph, filename);
    }
    vertex_scc_t starting = get_starting(scc_graph);

    do_bfs(starting);

    printf("%lu %lu\n", get_shortest_path(scc_graph, d), num_vertices(scc_graph));

    return 0;
}
