#include "helpers.cpp"

#include<cstdio>
#include<vector>

#include <boost/config.hpp>
#include <boost/graph/adjacency_list.hpp>
#include <boost/graph/graphviz.hpp>
#include <boost/graph/graph_utility.hpp>
#include <boost/graph/breadth_first_search.hpp>
#include <boost/property_map/property_map.hpp>

using namespace std;
using namespace boost;

typedef adjacency_list<listS, vecS, directedS, Vertex, Edge> Graph;
typedef graph_traits<Graph>::vertex_descriptor vertex_t;
typedef graph_traits<Graph>::vertices_size_type Size;

Graph G;
unsigned N;
vector<Size> d;

void do_bfs(vertex_t starting) {
    d.resize(N, 0);
    breadth_first_search(
            G, starting, 
            visitor(
                make_bfs_visitor(record_distances(&d[0], on_tree_edge()))
                ));
}

int main(int argc , char* argv[]) {
    if (argc < 2) {
        return 0;
    }
    string filename = argv[1];
    N = read(G, filename);

    vertex_t starting = get_starting(G);

    do_bfs(starting);

    printf("%lu %lu\n", get_shortest_path(G, d), num_vertices(G));

    return 0;
}
