USER_TIME_FILE = 'tilt_maze_user_time.csv'
LEVEL_LIST_URL = 'http://tutor.fi.muni.cz/index.php?p=instance_list&problem_id=13'
LOGIN_USER = 'Arasid'
LOGIN_PASSWD = '...'

FEATURES_FILE = 'features.csv'
TRAIN_FEATURES_FILE = 'features_train.csv'
TEST_FEATURES_FILE = 'features_test.csv'
TEST_IDS_FILE = 'test_ids.txt'

FEATURE_CNT = 10
FIELDNAMES = [
        'id', 'checkpoint_count', 'tile_count', 'width', 'reachable_tile_count', 'scc_count', 
        'scc_checkpoint_count', 'shortest_path', 'reachable_states_count', 'viable_states_count',
        'shortest_path_tiles',
        'avg_log_time', '25per', 'avg_time', 'stdev'
]

def get_predict_col(type):
    if type == 'avg_log':
        return FEATURE_CNT + 1
    if type == '25per':
        return FEATURE_CNT + 2
    if type == 'avg':
        return FEATURE_CNT + 3
    return None

def get_predict_col_name(type):
    col = get_predict_col(type)
    if col is None: return None
    return FIELDNAMES[col]

def get_level_name(id):
    return 'tilt_maze_id=%s.level' % str(id)

def get_level_url(id):
    return 'http://tutor.fi.muni.cz/index.php?p=instance_solve&instance_id=%s' % id
