/****************************************************************************
**
** Definition of QTriple class
**
** Copyright (C) 2002 Christian C. Berclaz.
**
** Based upon the QPair class from the Qt library of Trolltech AS
**
** Copyright (C) 1992-2001 Trolltech AS.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QTRIPLE_H
#define QTRIPLE_H

#ifndef QT_H
#endif // QT_H

template <class T1, class T2, class T3>
struct QTriple
{
	typedef T1 first_type;
	typedef T2 second_type;
	typedef T3 third_type;

	QTriple()
	: first( T1() ), second( T2() ), third( T3() )
	{}
	QTriple( const T1& t1, const T2& t2, const T3& t3 )
	: first( t1 ), second( t2 ), third( t3 )
	{}

	T1 first;
	T2 second;
	T3 third;
};

template <class T1, class T2, class T3>
inline bool operator==( const QTriple<T1, T2, T3>& x, const QTriple<T1, T2, T3>& y )
{
	return x.first == y.first && x.second == y.second && x.third == y.third;
}

template <class T1, class T2, class T3>
inline bool operator<( const QTriple<T1, T2, T3>& x, const QTriple<T1, T2, T3>& y )
{
	// x < y is TRUE if:
	// x.first is less than y.first,
	// or if x.second is less than y.second and x.first is the same as y.first
	// or if x.third is less than y.third and both x.first and x.second are the same as y.first and y.second respectively
	return x.first < y.first || ( !( y.first < x.first ) && x.second < y.second ) ||
		   (!( y.first < x.first) && !( y.second < x.second ) && x.third < y.third );
}

template <class T1, class T2, class T3>
inline QTriple<T1, T2, T3> qMakeTriple( const T1& x, const T2& y, const T3& z )
{
	return QTriple<T1, T2, T3>( x, y, z );
}

#endif
