#include <cmath>
#include "biddingdialog.h"
#include "ui_biddingdialog.h"

BiddingDialog::BiddingDialog(Game* g,QWidget *parent) :
    QDialog(parent),
    ui(new Ui::BiddingDialog)
{
	game = g;
	ui->setupUi(this);
}

BiddingDialog::~BiddingDialog()
{
    delete ui;
}

void BiddingDialog::startBidding(){
	game->profiler->start("bidding");
	history.clear();
	if(!game->quickGame){
		QRect mainW = game->marias->getGeometry();
		this->setGeometry(mainW.x()+350+(mainW.width()-802)/2,mainW.y()+280+(mainW.height()-641)/2,this->width(),this->height());
		this->show();
		this->raise();
		ui->textEdit->clear();
		if(game->stav.hra.farba)
			DeskView::revealCard(game->stav.hra.tromf);
	}
	if(game->players[game->stav.id]->type!="human" || game->quickGame)
		bid(game->players[game->stav.id]->bid()|4);
	else{
		updateUi();
		ui->checkBox_hra->setChecked(true);
	}
}

void BiddingDialog::endBidding(){
	if(!game->quickGame)
		qDebug() << "end bidding";
	game->stav.vysid = game->stav.forhont;
	game->stav.id = game->stav.forhont;
	game->stav.kolo = 0;
	if(!game->quickGame){
		if(game->stav.hra.farba)
			DeskView::ejectTromf(game->stav.hra.tromf,true);
		this->hide();
	}
	game->profiler->stop("bidding");
	game->profiler->stop("dealing and bidding");
	game->profiler->stop("game - prepare");
	game->profiler->start("game - trick taking");
	game->animationFinished(0);
}

void BiddingDialog::bid(int res){
	//spracuj bid

	if(!game->quickGame)
		qDebug() << game->players[game->stav.id]->name << ": " << res;
	QString text;

	bool ideForhont = game->stav.id == game->stav.forhont;

	if(res&4 && game->stav.hra.flekNaHru<128){
		if(game->stav.hra.flekNaHru == 0){
			if(ideForhont){
				text = tr("Hra!");
				game->stav.hra.flekNaHru = 1;
			}else qCritical() << "Opponent " << game->stav.id << " hlasi hru skor ako forhont!";
		}else{
			if(ideForhont ^ ((int)log2(game->stav.hra.flekNaHru)%2==0)){
				game->stav.hra.flekNaHru *= 2;
				text += tr("%1 na hru!").arg(GlobalStrings::flek(game->stav.hra.flekNaHru));
			}
		}
	}

	if(res&2 && game->stav.hra.flekNaSedmu<128){
		if(game->stav.hra.sedma){
			if(ideForhont ^ ((int)log2(game->stav.hra.flekNaSedmu)%2==0)){
				game->stav.hra.flekNaSedmu *= 2;
				text += tr("%1 na sedmu!").arg(GlobalStrings::flek(game->stav.hra.flekNaSedmu));
			}
		}else if(game->stav.hra.sedmaProti){
			if(ideForhont ^ ((int)log2(game->stav.hra.flekNaSedmu)%2==1)){
				game->stav.hra.flekNaSedmu *= 2;
				text += tr("%1 na sedmu proti!").arg(GlobalStrings::flek(game->stav.hra.flekNaSedmu));
			}
		}else{
			if(ideForhont){
				game->stav.hra.sedma = true;
				text += tr("Sedma!");
			}else{
				game->stav.hra.sedmaProti = true;
				text += tr("Sedma proti!");
			}
			game->stav.hra.flekNaSedmu = 1;
		}
	}

	if(res&1 && game->stav.hra.flekNaStovku<128){
		if(game->stav.hra.stovka){
			if(ideForhont ^ ((int)log2(game->stav.hra.flekNaStovku)%2==0)){
				game->stav.hra.flekNaStovku *= 2;
				text += tr("%1 na stovku!").arg(GlobalStrings::flek(game->stav.hra.flekNaStovku));
			}
		}else if(game->stav.hra.stovkaProti){
			if(ideForhont ^ ((int)log2(game->stav.hra.flekNaStovku)%2==1)){
				game->stav.hra.flekNaStovku *= 2;
				text += tr("%1 na sto proti!").arg(GlobalStrings::flek(game->stav.hra.flekNaStovku));
			}
		}else{
			if(ideForhont){
				game->stav.hra.stovka = true;
				text +=tr("Stovka!");
			}else{
				game->stav.hra.stovkaProti = true;
				text += tr("Sto proti!");
			}
			game->stav.hra.flekNaStovku = 1;
		}
	}

	bool endBid = false;
	if(text==""){
		if(ideForhont)endBid=true;
		else if(history.last()==0)endBid=true;//pred nim nebol forhont, lebo by to skoncilo uz predtym
		history.push_back(0);
		text=tr("Mlcim.");
	}else history.push_back(res);

	if(!game->quickGame)
		DeskView::print(text,game->stav.id);
	if(!game->quickGame)
		ui->textEdit->append(game->players[game->stav.id]->name+": "+text);
	if(endBid)return endBidding();

	game->stav.dalsi();
	if(game->players[game->stav.id]->type=="human"  && !game->quickGame)return updateUi();
	bid(game->players[game->stav.id]->bid());
}

void BiddingDialog::updateUi(){
	bool ideForhont = game->stav.id == game->stav.forhont;

	ui->checkBox_hra->setChecked(false);
	ui->checkBox_sedma->setChecked(false);
	ui->checkBox_stovka->setChecked(false);

	if(ideForhont && game->stav.hra.flekNaHru==0)
		ui->checkBox_hra->setText(tr("Hra"));
	else ui->checkBox_hra->setText(tr("%1 na hru").arg(GlobalStrings::flek(game->stav.hra.flekNaHru*2)));

	if(!game->stav.hra.sedma && !game->stav.hra.sedmaProti){
		if(ideForhont)
			ui->checkBox_sedma->setText(tr("Sedma"));
		else
			ui->checkBox_sedma->setText(tr("Sedma proti"));
	}else ui->checkBox_sedma->setText(tr("%1 na sedmu").arg(GlobalStrings::flek(game->stav.hra.flekNaSedmu*2)) + (game->stav.hra.sedmaProti?tr(" proti"):""));

	if(!game->stav.hra.stovka && !game->stav.hra.stovkaProti){
		if(ideForhont)
			ui->checkBox_stovka->setText(tr("Stovka"));
		else
			ui->checkBox_stovka->setText(tr("Stovka proti"));
	}else ui->checkBox_stovka->setText(tr("%1 na stovku").arg(GlobalStrings::flek(game->stav.hra.flekNaStovku*2)) + (game->stav.hra.stovkaProti?tr(" proti"):""));

	int bids = getAvailableBids();
	ui->checkBox_hra->setEnabled(bids&4);
	ui->checkBox_sedma->setEnabled(bids&2);
	ui->checkBox_stovka->setEnabled(bids&1);

	if(ideForhont && game->stav.hra.flekNaHru==0)
		ui->checkBox_hra->setEnabled(false);
}

int BiddingDialog::getAvailableBids(){
	int bids=0;
	bool ideForhont = game->stav.id == game->stav.forhont;

	if(game->stav.hra.flekNaHru==0 || (game->stav.hra.flekNaHru<128 && (((int)log2(game->stav.hra.flekNaHru)%2==0) ^ ideForhont))) bids |= 4;

	if(game->stav.hra.flekNaSedmu<128){
		if(game->stav.hra.flekNaSedmu==0)bids|=2;
		else if((((int)log2(game->stav.hra.flekNaSedmu)%2==0) ^ ideForhont) && game->stav.hra.sedma) bids |= 2;
		else if((((int)log2(game->stav.hra.flekNaSedmu)%2==1) ^ ideForhont) && game->stav.hra.sedmaProti) bids |= 2;
	}

	if(game->stav.hra.flekNaStovku<128){
		if(game->stav.hra.flekNaStovku==0)bids|=1;
		else if((((int)log2(game->stav.hra.flekNaStovku)%2==0) ^ ideForhont) && game->stav.hra.stovka) bids |= 1;
		else if((((int)log2(game->stav.hra.flekNaStovku)%2==1) ^ ideForhont) && game->stav.hra.stovkaProti) bids |= 1;
	}
	return bids;
}

void BiddingDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void BiddingDialog::on_pushButton_released()
{
	int res = 0;
	if(ui->checkBox_hra->checkState()==Qt::Checked) res|=4;
	if(ui->checkBox_sedma->checkState()==Qt::Checked) res|=2;
	if(ui->checkBox_stovka->checkState()==Qt::Checked) res|=1;
	bid(res);
}
