#include "datasets.h"
#include<QDebug>

Datasets::Datasets()
{
}

void Datasets::add(int index, qreal value)
{
    if(!this->data.keys().contains(index))
    {
        this->data.insert(index,QList<qreal>());
    }
    this->data[index].append(value);
}

qreal Datasets::getAvg(int index)
{
    if(this->data.value(index).size()==0)return 0.0;
    return this->getSum(index) / this->data.value(index).size();
}

qreal Datasets::getSum(int index)
{
    qreal sum = 0;
    for(int i=0;i<this->data.value(index).size();i++)
    {
        sum += this->data.value(index)[i];
    }
    return sum;
}

void Datasets::clear()
{
    this->data.clear();
}

void Datasets::print()
{
    QMap<int, QList<qreal> >::const_iterator i = this->data.constBegin();
    while (i != this->data.constEnd()) {
        qDebug() << " Expected reward " << i.key() << ": " << this->getAvg(i.key());
        ++i;
    }
}
