#ifndef DESKVIEW_H
#define DESKVIEW_H

/**
  *Main class for interaction with grahics view. It loads card images, stores pointers for graphics items in scene, and has many graphics functions.
  *It is singleton, so call some function is as simple as including deskview.h and calling static function DeskView::<som function>().
  *
  *TODO: split to more classes
  *
  *@class DeskView
  *@author Mirelon
  *
  */
class DeskView;

#include <QList>
#include <QString>
#include <QSettings>
#include <QSignalMapper>
#include <QGraphicsScene>
#include <QGraphicsItem>
#include <QGraphicsTextItem>
#include <QGraphicsEllipseItem>
#include <QFont>
#include <QPropertyAnimation>
#include <QSequentialAnimationGroup>
#include <QParallelAnimationGroup>
#include <QPixmap>
#include <QDir>
#include <QDirIterator>
#include <QDebug>
#include "ui_marias.h"
#include "player.h"
#include "game.h"
#include "carditem.h"

class DeskView
{
public:
	DeskView(Ui_Marias* ui,Game* g);
	~DeskView();
	static DeskView* Instance();
	/**
	  *Instance should be created only once. Now it is created by Marias class.
	  *It takes two arguments - ui of the marias for access to graphics view and game for access to state of the game and players
	  *
	  */
	static void createInstance(Ui_Marias* ui,Game* g);
	/**
	  *Instance is created by Marias, so it is also destroyed only by Marias.
	  *
	  */
	static void destroyInstance();

	void _cleanGraphics(bool all=false);
	/**
	  *Cleans graphics scene of graphics items, so they won't be stored in memory anymore.
	  *By default, cards and animations are not removed, because cards are not drawed, only moved, so they stay.
	  *Animations are removed after they are finished.
	  *
	  */
	static void cleanGraphics(bool all=false);

	void _gather();
	/**
	  *Gathers all cards from desk, cleans all animations if some remains and recreates the cards at deck.
	  *
	  */
	static void gather();

	void _intro();
	static void intro();

	void _rozdaj(int cid, int pid,int offset,int pause,bool last=false);
	/**
	  *Moves card with id cid to position so it appears at the hand of player with id pid at position offset.
	  *It is used during card dealing and in case when a players plays a card and a gap arises in the hand - the cards are shifted then.
	  *Note: offset is zero-based.
	  *
	  */
	static void rozdaj(int cid, int pid,int offset,int pause,bool last=false);

	void _fixHand(int pid,bool last);
	/**
	  *Moves cards in player's hand to their correct positions.
	  *
	  */
	static void fixHand(int pid,bool last=false);

	void _talon(int cid,bool last);
	/**
	  *Talon is a special keyword of this game. Google translated it as "kitty", but it evokes me some kind of cat:)
	  *The forhont chooses 2 cards that other players don't see and he is not playing with that cards. After this, all players has exactly 10 cards.
	  *Talon consists of that 2 cards and is located at the position of the former card pile.
	  *cid is id of the card, forhont wants to give away.
	  *If the flag last is on, it means, the last card has been given to talon and the finish of the animation is connected to next action.
	  *
	  */
	static void talon(int cid,bool last=false);

	void _ejectTromf(int cid,bool reverse);
	/**
	  *Tromf is also a special keyword, it is translated as "trump". It is a "chosen card" - chosen by forhont.
	  *The color(or suit) of the tromf will be stronger than other colors. At the start of the bidding, it is revealed to other players.
	  *Tromf is then displayed in front of forhont, so players can remember the chosen color.
	  *This function is only called after tromf has been chosen, so it only ejects the card softly to be visible.
	  *
	  */
	static void ejectTromf(int cid,bool reverse=false);

	void _revealCard(int cid);
	/**
	  *Sets the card image. If the former was back of the card, now it will be front.
	  *
	  */
	static void revealCard(int cid);

	void _hideCard(int cid);
	/**
	  *Sets the card image to back. The value of the card will therefore be hidden.
	  *
	  */
	static void hideCard(int cid);

	void _draw();

	/**
	  *Draws light at forhont, name labels with money, console with game messages and tromf suit.
	  *
	  */
	static void draw();

	void _drawResults();
	/**
	  *Cleans all the graphics and displays results. They are stored in game->stav.hra.results
	  *
	  */
	static void drawResults();

	void _animateCard(int cid,int pid);
	/**
	  *Animate card cid from player pid to the stack (poziciaKopy[pid])
	  *
	  */
	static void animateCard(int cid,int pid);

	void _animateStich(int pid);
	/**
	  *Animate stich(trick) - all 3 cards at the stack(kopa) are transferred to player pid.
	  *
	  */
	static void animateStich(int pid);

	void _show();
	//deprecated
	static void show();

	Game* _getGame();
	/**
	  *Dirty hook how anyone can easily get pointer to Game (Game have access to any class).
	  *
	  */
	static Game* getGame();

	void _print(QString s, int pos);
	/**
	  *Prints animated text s that says player with id pos. Also logs it.
	  *
	  */
	static void print(QString s, int pos=0);

	void _log(QString s);
	/**
	  *Adds given string to console output.
	  *
	  */
	static void log(QString s);

private:
	//instance
	static DeskView* instance;
	QGraphicsScene* graphicsScene;
	QGraphicsView* graphicsView;
	QSignalMapper* signalMapper;
	//Pointer to game
	Game* game;
	//Pointers to graphics items - cards. They are only moved from one position to another instead of creating and destroying.
	CardItem* cardItem[32];
	//Image of the card back.
	QPixmap rub;
	//Images of cards.
	QPixmap images[32];
	//Tromf icons images.
	QPixmap suits[4];
	//Console output.
	QList<QString> out;
	//positions in the graphics view for each of the 3 players:
	//stack
	QPoint poziciaKopy[3];
	//cards (upper left corner of the leftmost card)
	QPoint poziciaKariet[3];
	//tromf icon
	QPoint poziciaTromfu[3];
	//name label
	QPoint poziciaMena[3];
	//where stich(trick) goes when a players takes it
	QPoint poziciaStichov[3];
	//where supertext is animated
	QPoint poziciaTextu[3];
	//deck and then talon
	QPoint poziciaBase;
	//graphics items of forhont light
	QGraphicsEllipseItem* lightSimple[3];
	QGraphicsEllipseItem* lightGradient[3];
	QSettings* settings;
	QFont font;
};

#endif // DESKVIEW_H
