#ifndef GAME_H
#define GAME_H

/**
  *@class Game
  *@author Mirelon
  *
  *Most important class that handles events, manages players, cards and whole gameplay with results.
  *Main functions are *Clicked() and animationFinished().
  *TODO: split this class into more smaller with exact functionality.
  *
  */
class Game;

#include <QList>
#include <QDebug>
#include "player.h"
#include "deskview.h"
#include "stav.h"
#include "card.h"
#include "biddingdialog.h"
#include "marias.h"
#include "profiler.h"
#include "randomgeneratoripsc.h"

class Game : public QObject
{
	Q_OBJECT
public:
	Game(Marias* m);
	~Game();
    void init();
    void resetMoney();
	void results();
	/**
	  *When clicked on CardItem, it depends on stav.kolo (current gamestate) whether to execute cardClicked, talonClicked or tromfClicked.
	  *cardClicked is called when a human selects a card he wish to play.
	  *@see CardItem
	  *
	  */
	void cardClicked(int k);
	/**
	  *Returns "" if the card is valid. Error message otherwise.
	  *
	  */
	QString validateTalon(int k);
	/**
	  *When clicked on CardItem, it depends on stav.kolo (current gamestate) whether to execute cardClicked, talonClicked or tromfClicked.
	  *talonClicked is called when forhont wants to select card to talon.
	  *@see CardItem
	  *
	  */
	void talonClicked(int k);
	/**
	  *When clicked on CardItem, it depends on stav.kolo (current gamestate) whether to execute cardClicked, talonClicked or tromfClicked.
	  *tromfClicked is called when forhont wants to select tromf.
	  *@see CardItem
	  *
	  */
	void tromfClicked(int k);
	/**
	  *Current player wants to play card k, this function executes all necessities.
	  *
	  */
	bool turn(int k);
	void shuffleDeck();
	/**
	  *First round of card dealing. Forhont gets 7 cards, other 5.
	  *
	  */
	void rozdaj1();
	/**
	  *Second round of card dealing. All players get 5 cards.
	  *
	  */
	void rozdaj2();
	/**
	  *Switches player type for player at position i.
	  *
	  */
	void changePlayer(int i,QString newType);
	QSettings* settings;
	QList<Player*> players;
	QList<int> deck;
	//Current state of the game
	Stav stav;
	//if is now the human turn
	bool waitingForClick;
	BiddingDialog* bd;
	Marias* marias;
	bool quickGame;
	Profiler* profiler;
        RandomGeneratorIPSC rg;
        // for poeple test
        int stats[3];
public slots:
	void newGame();
	/**
	  *Major function, is responsible for future actions, that depends on game state.
	  *This is due to event driven programming, where main loop is hidden from programmers.
	  *This function must exist, maybe it can split some functionality in more functions.
	  *
	  */
	void animationFinished(int round);
};

#endif // GAME_H
