#include <QMessageBox>
#include <QDebug>
#include "marias.h"
#include "ui_marias.h"
#include "settingsdialog.h"
#include "deskview.h"

Marias::Marias(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::Marias)
{
    ui->setupUi(this);
	game = new Game(this);
	game->init();
	DeskView::createInstance(ui,game);
	sd = new SettingsDialog(game);
}

Marias::~Marias()
{
    delete sd;
    DeskView::destroyInstance();
    delete ui;
	delete game;
}

QRect Marias::getGeometry(){
	return this->geometry();
}

void Marias::show(){
	QWidget::show();
	DeskView::intro();
}

void Marias::on_actionQuit_triggered()
{
    QApplication::quit();
}

void Marias::on_actionNew_game_triggered()
{
    qDebug("new game");
	game->newGame();
    qDebug("new game end");
}

void Marias::on_actionAbout_triggered()
{
    QSettings* settings = new QSettings("marias.ini", QSettings::IniFormat);
	QMessageBox::about(this, "About...",
	"<b>OpenMarias</b>, free OPENsource Marias<br/>"
	"2009-2011 by Miso Kovac<br/>"
	"See <a href='http://sourceforge.net/projects/openmarias'>http://sourceforge.net/projects/openmarias</a>"
    "<br/>"
	"Version: <b>"
    +settings->value("version/major",0).toString()+"."
    +settings->value("version/minor",0).toString()+
    (settings->value("version/revision",0)==0?"":"."+settings->value("version/revision",0).toString())+"</b>");
}

void Marias::on_actionSettings_triggered()
{
    sd->show();
    //if sd is showed, but covered by other windows, then bring it to front
    sd->raise();
}
