#include "player.h"
#include "players/randomplayer.h"
#include "players/minplayer.h"
#include "players/maxplayer.h"
#include "players/smartplayer.h"

Player::Player()
{
	type = "default";
	body = 0;
	peniaze = 0;
}

Player::~Player()
{

}

void Player::init()
{
	//abstract
}

void Player::setStav(Stav* s){
	stav = s;
}

void Player::setId(int pid){
	id = pid;
}

int Player::play(){
        qDebug() << "default";
		return -1;
	//abstract
}

int Player::talon(){
		qDebug() << "default";
		return -1;
	//abstract
}

int Player::tromf(){
		qDebug() << "default";
		return -1;
	//abstract
}

int Player::bid(){
		qDebug() << "default";
		return -1;
	//abstract
}

void Player::removeCard(int cid){
	for(int i=0;i<hand.count();i++)
		if(hand[i]==cid){
			hand.removeAt(i);
			return;
		}
	qCritical() << "Player::removeCard(): " << name << " dont have " << cid;
}

void Player::say(QString s){
	qDebug() << "(" << type << ") " << name << ": " << s;
    this->message.append(" "+s);
}

bool Player::mozePrebit(int cid, Stav* s,QList<int>* h){
	if(s==NULL)s=stav;
	if(h==NULL)h=&hand;
	foreach(int c,*h){
		if(Card::stronger(c,cid,s->hra))
			return true;
	}
	return false;
}

bool Player::mozePrebitCisto(int cid, Stav* s,QList<int>* h){
	if(s==NULL)s=stav;
	if(h==NULL)h=&hand;
	foreach(int c,*h){
		if(Card::equalColor(c,cid) && Card::stronger(c,cid,s->hra)){
			return true;
		}
	}
	return false;
}

bool Player::maFarbu(int cid, QList<int>* h){
	if(h==NULL)h=&hand;
	foreach(int c,*h){
		if(Card::equalColor(c,cid))
			return true;
	}
	return false;
}

bool Player::somForhont(){
	return stav->forhont==id;
}

int Player::tromfCount(Stav* s, QList<int>* h){
	if(s==NULL)s=stav;
	if(h==NULL)h=&hand;
	int t=0;
	foreach(int cid,*h)
		if(Card::isTromf(cid,s->hra))
			t++;
	return t;
}

QString Player::validate(int cid, Stav* s, QList<int>* h){
	if(s==NULL)s=stav;
	if(h==NULL)h=&hand;
	if(!h->contains(cid))return QObject::tr("%1 nemas").arg(Card::titleA(cid));
		if(Card::value(cid)=="kral" && h->contains(cid-1))return QObject::tr("Z hlasky najprv hornika");
	if(s->kopa.count()==0)return "";
	int kop = s->kopa[0]; //kop = card that beats the stack at last
	if(s->kopa.count()==2){
		if(Card::stronger(s->kopa[1],s->kopa[0],s->hra))
			kop = s->kopa[1];
	}

	bool prebil = Card::stronger(cid,kop,s->hra);
	bool equalColor = Card::equalColor(s->kopa[0],cid);
	bool prebilCisto = prebil && equalColor;

	if(maFarbu(s->kopa[0],h) && !equalColor)return QObject::tr("Treba priznat farbu");
	if(Card::equalColor(s->kopa[0],kop) && mozePrebitCisto(kop,s,h) && !prebilCisto)
		return QObject::tr("Treba prebit cisto");
	if(equalColor)return "";
	if(mozePrebit(kop,s,h) && !prebil)return QObject::tr("Treba prebit");
	if(tromfCount(s,h)>0 && !Card::isTromf(cid,s->hra))return "Treba dat tromf";
	return "";
}

QList<int> Player::getLegalList(Stav* s, QList<int>* h){
	if(s==NULL)s=stav;
	if(h==NULL)h=&hand;
	QList<int> legal;
	for(int i=0;i<h->size();i++)
		if(validate(h->at(i),s,h)=="")
			legal.push_back(h->at(i));
	return legal;
}

void Player::sortHand(){
	qSort(hand.begin(),hand.end(),Card::less);
}
