#ifndef PLAYER_H
#define PLAYER_H

/**
  *@class Player
  *@author Mirelon
  *
  *Player is class that is partially abstract. Extending classes implement it's virtual methods.
  *It also stores player data.
  *
  */
class Player;

#include <QString>
#include <QList>
#include <QDebug>
#include "stav.h"
#include "card.h"
#include "profiler.h"
#include "randomgeneratoripsc.h"

class Player
{
public:
    Player();
	~Player();
	virtual void init();
	void setStav(Stav* s);
	void setId(int pid);
	/**
	  *@param stav State of the game.
	  *@return int Id of the played card.
	  *
	  */
	virtual int play();
	/**
	  *@param stav State of the game.
	  *@return int Id of two cards for talon (32*id_1 + id_2).
	  *
	  */
	virtual int talon();
	/**
	  *@return int Id of the tromf card.
	  *
	  */
	virtual int tromf();
	/**
	  *@param stav State of the game.
	  *@return int Bid (3 bits in one number less than 8)
	  *First bit is whether the player bids the game, second is bid for the seven and third is bid for the hundred.
	  *
	  */
	virtual int bid();
	/**
	  *Removes card from hand.
	  *
	  */
	void removeCard(int cid);
	void say(QString s);
	/**
	  *Utility method, used by validation, it must check, if the player is able to beat given card (to beat = prebit).
	  *@see validate
	  *
	  */
	bool mozePrebit(int cid, Stav* s = NULL,QList<int>* h = NULL);
	/**
	  *Utility method, used by validation, it must check, if the player is able to beat given card (to beat = prebit) with card of same color(suit).
	  *@see validate
	  *
	  */
	bool mozePrebitCisto(int cid, Stav* s = NULL,QList<int>* h = NULL);
	/**
	  *Utility method, used by validation, it checks, if the player can play a card with same color.
	  *@see validate
	  *
	  */
	bool maFarbu(int cid, QList<int>* h = NULL);
	bool somForhont();
	int tromfCount(Stav* s = NULL,QList<int>* h = NULL);
	/**
	  *Checks, if the card is valid (can be played) in current game state.
	  *Or in the given state with given hand.
	  *
	  */
	QString validate(int cid, Stav* s = NULL,QList<int>* h = NULL);
	/**
	  * Returns list of cards that are allowed to play.
	  * Optional in the given state and with given hand.
	  *
	  */
	QList<int> getLegalList(Stav* s = NULL,QList<int>* h = NULL);
	void sortHand();
	QString name;
	QString type;
	QList<int> hand;
	//points
	int body;
	//money
	int peniaze;
	//pocet hlasok
	int hlasky;
	Stav* stav;
	int id;
	QString message;
	bool quickGame;
	Profiler* profiler;
        RandomGeneratorIPSC rg;
	int talonCards[2]; //if the player is forhont, he should know what is in talon
};

#endif // PLAYER_H
