#include "maxplayer.h"

MaxPlayer::MaxPlayer()
{
	type = "maximalista";
	name = "Maximalista";
}

int MaxPlayer::play(){
	return pickMax(getLegalList());
}

int MaxPlayer::talon(){
	QList<int> legal;
	foreach(int c,hand){
		if(Card::value(c)!="10" && Card::value(c)!="eso" && c!=stav->hra.tromf)
			legal.push_back(c);
	}
	return pickMaxTwo(legal);
}

int MaxPlayer::bid(){
	int bids=0;
	if(hand.contains(stav->hra.tromf7()) && stav->hra.flekNaSedmu<16)bids|=2;
	if(stav->hra.flekNaHru<4)bids|=4;
	return bids;
}

int MaxPlayer::tromf(){
	return pickMax(hand);
}

int MaxPlayer::pickMax(QList<int> legal){
	int Max = 0;
	foreach(int c,legal){
		if(c%8>=Max%8)Max=c;
	}
	return Max;
}

int MaxPlayer::pickMaxTwo(QList<int> legal){
	int Max1 = pickMax(legal);
	int Max2 = 0;
	foreach(int c,legal){
		if(c!=Max1 && c%8>=Max2%8)Max2=c;
	}
	return Max2*32 + Max1;
}
