#include "evaluator.h"
#include <QtCore/qmath.h>

Evaluator::Evaluator()
{
}

qreal Evaluator::evaluate(Stav *s)
{
    return 0;
}

qreal Evaluator::evaluate(const MyStav *ms)
{
    qreal res = 0;
    if(ms->stav.hra.flekNaSedmu)
    {
        res += ms->stav.hra.flekNaSedmu * (2.0*evaluateSedma(ms)-1.0);
    }
    if(ms->stav.hra.flekNaStovku)
    {
        res += ms->stav.hra.flekNaStovku * evaluateStovka(ms);
    }
    if(ms->stav.hra.flekNaHru)
    {
        res += ms->stav.hra.flekNaHru * (2.0*evaluateHra(ms)-1.0);
    }
//    qDebug() << res;
    return res;
}

qreal Evaluator::evaluateSedma(const MyStav *ms)
{
     if(ms->stav.hra.flekNaSedmu == 0){
        return 0;
    }
    int forhontTromfs = 0;
    foreach(int c,ms->hand[ms->stav.forhont]){
        if(Card::isTromf(c,ms->stav.hra)){
            forhontTromfs++;
        }
    }
    int oppTromfs = 0;
    foreach(int c,ms->hand[(ms->stav.forhont+1)%3]){
        if(Card::isTromf(c,ms->stav.hra)){
            oppTromfs++;
        }
    }
    int oppCards = ms->hand[(ms->stav.forhont+1)%3].size();
    int opp2Tromfs = 0;
    foreach(int c,ms->hand[(ms->stav.forhont+2)%3]){
        if(Card::isTromf(c,ms->stav.hra)){
            opp2Tromfs++;
        }
    }
//    qDebug() << "sedma" << forhontTromfs << oppTromfs << opp2Tromfs << oppCards;
    int opp2Cards = ms->hand[(ms->stav.forhont+2)%3].size();
    if(opp2Tromfs>oppTromfs)
    {
        oppTromfs = opp2Tromfs;
        oppCards = opp2Cards;
    }
    //heuristic evaluating upon forhontTromfs, oppTromfs, oppCards
    if(!ms->hand[ms->stav.forhont].contains(ms->stav.hra.tromf7()))return 0.0;
    if(oppCards==0)return 1.0;
    if(forhontTromfs >= 5)return 1.0;
    if(forhontTromfs-oppTromfs >= 3)return 1.0;
    if(oppTromfs == oppCards)return 0.0;
    if(forhontTromfs==1 && oppTromfs==0)return 1.0/qSqrt(oppCards);
    if(forhontTromfs==2 && oppTromfs==0){
        if(oppCards<=2)return 1.0;
        return 1.0/qSqrt(qSqrt(oppCards-2));
    }
    if(forhontTromfs==3 && oppTromfs==1){
        if(oppCards<=2)return 1.0;
        return 1.0/qSqrt(qSqrt(qSqrt(oppCards-2)));
    }
    if(forhontTromfs==4 && oppTromfs==2){
        if(oppCards<=2)return 1.0;
        return 1.0/qSqrt(oppCards-2);
    }
    if(forhontTromfs==1 && oppTromfs==1){
        if(oppCards==1)return 0.0;
        return 0.3;
    }
    if(forhontTromfs==2 && oppTromfs==1){
        if(oppCards==1)return 0.0;
        return 0.4;
    }
    if(forhontTromfs==3 && oppTromfs==2){
        if(oppCards<4)return 0.2*(oppCards-2);
        return 0.4;
    }
    if(forhontTromfs==4 && oppTromfs==3){
        if(oppCards<6)return 0.0;
        if(oppCards<9)return 0.1*(oppCards-5);
        return 0.3;
    }
    if(forhontTromfs == oppTromfs){
        if(oppCards - 2*oppTromfs < 0)return 0.0;
        return 0.1*qSqrt(oppCards - 2*oppTromfs + 1);
    }
    if(forhontTromfs < oppTromfs){
        return 0.0;
    }
    return 0.0;
}

qreal Evaluator::evaluateStovka(const MyStav *ms)
{
    if(ms->stav.hra.flekNaSedmu == 0)
    {
        return 0;
    }
    //TODO
    return 0;
}

qreal Evaluator::evaluateHra(const MyStav *ms)
{
    if(ms->hand[0].size()==0)
    {
        return ms->stav.hra.forhontPoints > ms->stav.hra.oppPoints ? 1 : 0;
    }
    int body[3] = {0,0,0}; //potencial ruk
    int forhontPoints = ms->stav.hra.forhontPoints; //body forhonta
    int oppPoints = ms->stav.hra.oppPoints; //body protihracov

    int maxTromfov = 0;
    int daSaZiskatBodov = 10; //za posledny stich
    for(int i=0;i<3;i++)
    {
        for(int farba=0;farba<4;farba++)
        {
            if(ms->hand[i].contains(5+8*farba) && ms->hand[i].contains(6+8*farba))
            {
                int bodyZaHlasku = 20;
                if(Card::isTromf(5+8*farba,ms->stav.hra))
                {
                    bodyZaHlasku = 40;
                }
                if(i==0)
                {
                    forhontPoints += bodyZaHlasku;
                }
                else
                {
                    oppPoints += bodyZaHlasku;
                }
            }
        }
        int pocetTromfov = 0;
        for(int j=0;j<ms->hand[i].size();j++)
        {
            int c = ms->hand[i].at(j);
            if(Card::isTromf(c,ms->stav.hra))
            {
                pocetTromfov ++;
            }
            if(Card::isFatty(c))
            {
                daSaZiskatBodov += 10;
            }
        }
        if(maxTromfov < pocetTromfov)
        {
            maxTromfov = pocetTromfov;
        }
    }

    qreal maxPomerTromfov = (qreal)maxTromfov / (qreal)(ms->hand[0].size());

    for(int i=0;i<3;i++)
    {
        for(int j=0;j<ms->hand[i].size();j++)
        {
            int c = ms->hand[i].at(j);

            if(Card::isTromf(c,ms->stav.hra))
            {
                body[i] += 8.0+(qreal)Evaluator::silaKarty(c);
            }
            else
            {
                body[i] += (1.0-maxPomerTromfov) * (qreal)Evaluator::silaKarty(c);
            }
        }
    }

    qreal potencialForhonta = (qreal)(body[0] + 1) / (qreal)(body[0] + body[1] + body[2] + 1);
    qreal napinavost = (qreal)daSaZiskatBodov / (qreal)(forhontPoints - oppPoints + 1);
    if(napinavost>=0 && napinavost<1)
    {
        return 1; //je to pre protihracov beznadejne
    }
    if(napinavost>-1 && napinavost<0)
    {
        return 0; //je to pre forhonta beznadejne
    }
//    qDebug() << "(napinavost,  potencial forhonta) =" << napinavost << potencialForhonta;
    qreal exponent = (5.0-5.0/napinavost)-10*potencialForhonta;
    qreal ret = 1.0/(1.0+exp(exponent));
//    qDebug() << "ret" << ret;
    return ret;

//    ms->stav.vysid; //ten vychadza
}

int Evaluator::silaKarty(int c)
{
    int sila = 0;
    int cPom=0;
    while(c%8 != cPom)
    {
        sila ++;
        cPom = Card::plus1(cPom);
    }
    return sila;
}
