#ifndef EVALUATOR_H
#define EVALUATOR_H

#include "../../stav.h"
#include "mystav.h"
#include "rozdania.h"
#include "../../card.h"

class Evaluator
{
public:
    Evaluator();
    static qreal evaluate(Stav* s);
    static qreal evaluate(const MyStav* ms);
    static bool less(MyStav const& ms1, MyStav const& ms2)
    {
        return (evaluate(&ms1)<evaluate(&ms2));
    }
    static bool greater(MyStav const& ms1, MyStav const& ms2)
    {
        return (evaluate(&ms1)>evaluate(&ms2));
    }

private:
    static qreal evaluateSedma(const MyStav* ms);
    static qreal evaluateStovka(const MyStav* ms);
    static qreal evaluateHra(const MyStav* ms);
    static int silaKarty(int c);
};

#endif // EVALUATOR_H
