#include<QDebug>
#include<QString>
#include "mystav.h"
#include "evaluator.h"


MyStav::MyStav(Player* p){
	me = p;
}

MyStav::MyStav(MyStav *s){
	me = s->me;
	stav = s->stav;
	for(int i=0;i<3;i++)
		hand[i] = s->hand[i];
}

qreal MyStav::evaluate(){
    return Evaluator::evaluate(this);
}

MyStav MyStav::makeMove(int c){
	MyStav s(this);
	if(me->validate(c,&stav,&hand[stav.id])!=""){
		qDebug() << "Error in searching, card " << QString::number(c) << "is not valid";
		return s;
	}
	if(Card::value(c)=="hornik" && s.hand[s.stav.id].contains(c+1)){
		int hlaska = 20;
		if(Card::isTromf(c,s.stav.hra))
			hlaska = 40;
		stav.hlaska(hlaska);
	}
	s.stav.cHist.push_back(c);
	for(int i=0;i<3;i++)
		s.hand[i].removeAll(c);
	s.stav.kopa.push_back(c);
	s.stav.dalsi();
	if(s.stav.kopa.count()==3){
		s.stav.kolo++;
		s.stav.vysid = s.stav.trick();
		s.stav.id = s.stav.vysid;
		s.stav.pHist.push_back(s.stav.id);
		s.stav.kopa.clear();
	}
	return s;
}

QList<MyStav> MyStav::generate(){
	QList<MyStav> qlms = QList<MyStav>();
	QList<int> legal = me->getLegalList(&stav,&hand[stav.id]);
	qSort(legal.begin(),legal.end(),Card::less); // 7 8 9 D H K 10 E
	//qDebug() << "generate: legal list: " << legal;


	// OREZAVANIE - NEMUSIM PREHLADAVAT VETVY, KDE DAM 8,9,D,H,K
	QList<int> legal2;

	// ALE TO ROBIM, LEN KED MAM PRED SEBOU VELA ROBOTY - HLBKA ASPON 4
	if(hand[stav.id].size()<2){
		legal2 = legal;
	}else{
		legal.push_back(32); //token that will always push the last legal card
		int lastLegal = legal[0]; //gulova 7
		for(int i=1;i<legal.size();i++){
			if(Card::equalColor(lastLegal,legal[i])){
				if(Card::isFatty(legal[i])){
					legal2.push_back(lastLegal);
					lastLegal = legal[i];
				}else if(lastLegal%8==0){
					legal2.push_back(lastLegal);
					lastLegal = legal[i];
				}else{
					//THE CASE OF AT LEAST TWO OF 8,9,D,H,K CONSECUTIVE
					for(int j=Card::plus1(lastLegal,true);j!=legal[i];j=Card::plus1(j)){
						if(hand[(stav.id+1)%3].contains(j) || hand[(stav.id+2)%3].contains(j)){
							//EXCEPT IF OTHER PLAYER HAS A CARD BETWEEN
							legal2.push_back(lastLegal);
							lastLegal = legal[i];
							break;
						}
					}

				}
			}else{
				legal2.push_back(lastLegal);
				lastLegal = legal[i];
			}
		}
	}
	//qDebug() << "orezany: " << legal2;


	foreach(int c,legal2){
		qlms.push_back(this->makeMove(c));
	}
	return qlms;
}

void MyStav::checkIntegrity(){
	int totalCards = stav.cHist.size() + 2 + hand[0].size() + hand[1].size() + hand[2].size();
	QString s = "hands: ";
	for(int i=0;i<3;i++){
		s += "(";
		for(int j=0;j<hand[i].size();j++)
			s += Card::title(hand[i][j]) + ", ";
		s += ") ";
	}

	if(totalCards!=32){
		qDebug() << s;
		qDebug() << "talon: " << Card::title(talon[0]) << Card::title(talon[1]);
		qDebug() << "INTEGRITY CHECK ERROR: total cards " << totalCards;
	}
}

int MyStav::getHeight(){
	return hand[0].size()+hand[1].size()+hand[2].size();
}

