#ifndef MYSTAV_H
#define MYSTAV_H

class MyStav;
// has size less than 350 B

#include "../../player.h"
#include "evaluator.h"

class MyStav
{
public:
	MyStav(Player* p);
	MyStav(MyStav* s);
	/**
	  *Heuristic evaluation of state.
	  *
	  */
	qreal evaluate();
	/**
	  *Simulates playing card c in current state and returns new state.
	  *
	  */
	MyStav makeMove(int c);
	/**
	  *Generates list of all possible states after one move.
	  *
	  */
	QList<MyStav> generate();
	void checkIntegrity();
	/**
	  *	Return number of turns to end of game.
	  *
	  */
    int getHeight();

	Player* me;
	Stav stav;
	QList<int> hand[3];
	int talon[2];

};
#endif // MYSTAV_H
