#ifndef ROZDANIA_H
#define ROZDANIA_H

#include <QList>
#include <QtConcurrentFilter>
#include "../../stav.h"
#include "../../profiler.h"

class Rozdania
{
public:
	Rozdania();
	~Rozdania();
	// list of possible distributions
	//format is:
	// 32 bit string of 0s and 1s
	// first 22 bits tells about which cards has which player
	// r[getCardPosInRozdanie(i)] = 1 => hrac vpravo ma kartu i
	// r[getCardPosInRozdanie(i)] = 0 => hrac vlavo ma kartu i alebo je v talone, alebo uz bola, alebo ju mam ja
	// getCardPosInRozdanie je surjekcia 32 -> 22, pre 22 neznamych kariet je to bijekcia
	// zvysnych 10 bitov koduje 2 karty v talone
	QList<int> r;
	QList<int> positions;
	QList<int> hand;
	int talon[2];
	/**
	  Rozdanie ma 32 bitov. Prvych 22 hovoria o tom, kto vlastni jednotlive karty.
	  Na i-tej pozicii je 0 ak ma danu kartu hrac vlavo odo mna, 1, ak vpravo.
	  22 bitov je preto, ze sa preskakuju karty, o ktorych viem, ze ich mam ja.
	  Poslednych 10 bitov koduje 2 karty v talone.

	  */
	void initPositions();
	QList<int> generujRecursive(QList<int> universe,int kolko,int timeLimit);
	void generuj(bool somForhont, int myID, int timeLimit);
	int getCardPosInRozdanie(int c);
	int getCardMask(int c);
	int getMask(int pos);
	/**
	  * Returns pair (left,right) from rozdanie at por-th position in list r
	  * left is cards that has left player
	  * right is cards that has right player
	  *
	  */
	QPair<QList<int>, QList<int> > getCardsAtRozdanie(int por);
	/**
	  * Helper function to update isOne and isZero arrays.
	  *
	  */
	void p2nemaC(QList<int>* isOne,QList<int>* isZero,int bit,int c);
	Stav* stav;
	bool quickGame;
	bool fail; // this flag is true if the time is up
	Profiler* profiler;
};

#endif // ROZDANIA_H
